set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4442',
      '41331304',
      '20133120',
      '34300123',
      '31324200',
      '04023110',
      '13311104',
      '40341130',
      '02321110',
      '20020124',
      '13304110',
      '30241404',
      '34422243',
      '20023133',
      '31031302',
      '20413244',
      NULL,
      '43322301',
      '32223433',
      NULL,
      '21144431',
      NULL,
      '30224314',
      '12120012',
      '34021041',
      '31243040',
      '34134243',
      '20124420',
      '04213202',
      NULL,
      '14124220',
      '43412244',
      '24434320',
      '20142213',
      NULL,
      NULL,
      '42041002',
      '20204220',
      '10034310',
      '10004423',
      NULL,
      NULL,
      NULL,
      '03444410',
      NULL,
      '213',
      '42',
      9,
      1.230407,
      '3311312',
      3,
      150.387448,
      3,
      NULL,
      '114210',
      2.972685,
      ' 3-25-1996',
      NULL,
      134,
      100,
      31,
      21,
      18,
      19,
      NULL,
      3,
      15,
      0.718950,
      5.304659,
      6,
      25,
      13.059059,
      0,
      NULL,
      18.590361,
      12.176777,
      NULL,
      1.447073,
      66.486584,
      NULL,
      NULL,
      7.981570,
      0,
      6.125617,
      124,
      84.523886,
      NULL,
      60.412015,
      98.051320,
      ' 2-25-1982',
      4,
      33,
      24,
      NULL,
      NULL,
      4,
      ' 0-16-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      9.262689,
      2.745277,
      NULL,
      5.369393,
      NULL,
      3.269965,
      0.718004,
      118.315244,
      1,
      0.616538,
      24,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-26-1980',
      NULL,
      10.929292,
      99.950844,
      46,
      33.909619,
      103,
      1,
      NULL,
      93,
      52.468171,
      8.982024,
      NULL,
      '11-12-1977',
      31,
      25,
      7.949891,
      47,
      83.768798,
      85.690085,
      5.799001,
      ' 7- 0-1983',
      27,
      NULL,
      ' 7- 6-1989',
      NULL,
      3,
      13,
      3,
      19.023050,
      2.691568,
      NULL,
      4.273936,
      0,
      132,
      1,
      NULL,
      4,
      28,
      0,
      2.660022,
      3.953292,
      0,
      ' 4-15-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      60.301613,
      7.716968,
      ' 5- 9-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-26-1983',
      48,
      ' 2- 7-1996',
      6.184938,
      12,
      '11-24-1989',
      36,
      NULL,
      '11- 5-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 4- 8-1978',
      1.397666,
      54,
      21.071360,
      ' 1-24-1988',
      1.790238,
      62,
      NULL,
      6.210903,
      54.143364,
      5,
      60.098141,
      ' 9-16-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


