set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '0',
      '0',
      NULL,
      '0',
      '2',
      '4',
      '3',
      '2',
      '3',
      '1',
      '4',
      '1',
      NULL,
      '0',
      '3',
      '2',
      '4',
      '3',
      '2',
      '1',
      '2',
      '2',
      '',
      '2',
      '',
      '4',
      '3',
      '1',
      '4',
      '1',
      '',
      NULL,
      '1',
      NULL,
      '4',
      '1',
      '4',
      '2',
      NULL,
      '1',
      '2',
      '0',
      '1',
      '423',
      '41103120',
      3,
      NULL,
      '2403201',
      2,
      151.585945,
      2,
      NULL,
      NULL,
      1,
      ' 0-17-1987',
      NULL,
      NULL,
      59.377173,
      27.205231,
      20,
      11,
      0,
      NULL,
      NULL,
      16,
      11,
      NULL,
      NULL,
      23,
      3.994441,
      22,
      NULL,
      4.105237,
      26.830167,
      20.631328,
      NULL,
      52,
      2,
      NULL,
      NULL,
      0,
      17.376322,
      172.908374,
      4,
      71,
      104,
      43.438318,
      ' 0- 9-1990',
      21,
      9.592480,
      3,
      12.777819,
      99.396836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      75,
      24.054924,
      NULL,
      10.546154,
      NULL,
      3,
      ' 0- 5-1997',
      1.696414,
      1,
      134.462362,
      NULL,
      NULL,
      34.009438,
      0.761941,
      1,
      69.646148,
      NULL,
      NULL,
      NULL,
      ' 5- 2-1975',
      75.596410,
      47,
      70.582499,
      29.404693,
      53.868055,
      25,
      NULL,
      NULL,
      62,
      51.720909,
      NULL,
      71.040267,
      ' 4-28-2000',
      21.137938,
      NULL,
      17.822402,
      61.973499,
      8.665626,
      37.234455,
      0,
      NULL,
      29,
      NULL,
      ' 8-17-1990',
      NULL,
      10,
      2,
      21.997455,
      1.673036,
      0.880601,
      0.085412,
      NULL,
      1.931872,
      NULL,
      1.661703,
      0,
      NULL,
      NULL,
      1.314150,
      1.596665,
      0,
      1.089784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69.803375,
      NULL,
      ' 5- 5-2003',
      NULL,
      NULL,
      NULL,
      60,
      ' 3- 6-1991',
      NULL,
      ' 6- 1-1985',
      0.195624,
      0.102686,
      ' 9-14-1991',
      10,
      60.609330,
      ' 5- 8-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      30,
      '10-12-1977',
      32.984987,
      13,
      NULL,
      ' 0- 8-1999',
      1,
      113,
      ' 5-25-1997',
      6.664732,
      27.263191,
      20,
      NULL,
      '10-25-1981',
      NULL,
      0,
      6.950893,
      '11-28-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


