set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816668';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      '0',
      '4',
      '3',
      '1',
      '3',
      '3',
      '3',
      '2',
      '1',
      '2',
      '0',
      '0',
      '1',
      '2',
      '4',
      NULL,
      '1',
      '1',
      '1',
      '2',
      NULL,
      '',
      '3',
      NULL,
      '3',
      '3',
      '4',
      '3',
      NULL,
      '',
      '',
      NULL,
      '0',
      '4',
      '0',
      '0',
      NULL,
      '4',
      NULL,
      '3',
      '4',
      '4',
      NULL,
      '00034444',
      39,
      87.966342,
      '0323312',
      3.524657,
      NULL,
      1,
      1,
      '243134',
      5.888841,
      ' 7-23-1981',
      NULL,
      22,
      80.280331,
      37,
      14,
      NULL,
      18,
      NULL,
      10.437772,
      11,
      7.124988,
      14,
      6,
      22.932495,
      8.190658,
      24,
      23,
      21.600015,
      27.180529,
      31,
      18,
      1,
      14,
      71.988423,
      NULL,
      1,
      16.569242,
      169,
      71,
      NULL,
      198.187299,
      170.035911,
      ' 3-15-1989',
      21,
      43.400247,
      19.155736,
      6,
      93,
      84.360373,
      '10-22-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.882072,
      NULL,
      26,
      24.408507,
      33,
      1.755992,
      ' 8- 4-1996',
      0,
      1,
      90.789512,
      1.290394,
      1.602187,
      52,
      1.092272,
      1.748344,
      60,
      NULL,
      NULL,
      NULL,
      ' 0-10-2003',
      64,
      72.999704,
      87.041375,
      NULL,
      48,
      5.776813,
      68.267879,
      13.226199,
      18.847797,
      11,
      41.408153,
      2.943015,
      ' 8-29-1975',
      NULL,
      0.079542,
      9,
      14,
      43,
      NULL,
      2.758300,
      ' 8- 8-2003',
      7,
      7.383207,
      '10-11-1991',
      9.568587,
      NULL,
      12,
      NULL,
      18.487032,
      2,
      1.443807,
      5,
      1,
      114.733808,
      0.271638,
      0.366437,
      7.513301,
      10,
      0,
      NULL,
      0,
      NULL,
      '11-18-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      12,
      '11- 9-1980',
      NULL,
      NULL,
      NULL,
      26.086193,
      NULL,
      13.159021,
      ' 9-18-1985',
      12.153940,
      10.418279,
      ' 3-12-1981',
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      12,
      ' 8-29-1995',
      26,
      11.345403,
      9,
      ' 8-28-1984',
      0,
      67.501966,
      ' 5-18-1982',
      18.801591,
      20,
      10,
      36.510431,
      ' 8-17-1985',
      33.328010,
      1,
      58.192762,
      ' 0- 7-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


