set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7116147';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0242',
      '01442103',
      '31143412',
      NULL,
      NULL,
      NULL,
      '41441313',
      '23341201',
      '21140000',
      '02203143',
      '40113414',
      '10102103',
      '20114341',
      NULL,
      '12210232',
      NULL,
      '42034224',
      '20440013',
      '24002203',
      NULL,
      '41400344',
      NULL,
      NULL,
      '32401443',
      '13311344',
      '23144330',
      '30444111',
      NULL,
      NULL,
      NULL,
      NULL,
      '13303043',
      '03431103',
      '34200440',
      '00032413',
      '41440042',
      '34413130',
      '22030221',
      '44012131',
      NULL,
      '02343344',
      NULL,
      '24104304',
      '14204310',
      '24311333',
      '210',
      '40',
      NULL,
      9.027558,
      '1201222',
      1,
      NULL,
      2,
      NULL,
      NULL,
      0.391013,
      ' 0-29-1980',
      ' 6-24-1983',
      61.808826,
      22,
      44,
      NULL,
      36.723181,
      2,
      40.891552,
      11.461133,
      NULL,
      24.488455,
      27.381935,
      NULL,
      10.819352,
      12,
      16.121734,
      4,
      25,
      18.451447,
      32.376975,
      16.097459,
      NULL,
      1.218939,
      NULL,
      NULL,
      1.480957,
      24.374805,
      140.180980,
      68,
      164,
      24,
      57,
      ' 2- 9-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      111.972512,
      0,
      0,
      7,
      1.983284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-2002',
      73.707144,
      NULL,
      86,
      40.497363,
      15,
      108.815163,
      NULL,
      15,
      NULL,
      48.798486,
      64.185635,
      94,
      NULL,
      6.968407,
      NULL,
      23.164905,
      NULL,
      59,
      NULL,
      7,
      ' 3-23-1998',
      NULL,
      NULL,
      NULL,
      17.759733,
      NULL,
      21,
      20.591896,
      2.066701,
      NULL,
      1,
      22.406478,
      NULL,
      NULL,
      3.066157,
      2.611693,
      15.579918,
      27,
      0,
      NULL,
      0,
      NULL,
      ' 5-27-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61.679169,
      59.581728,
      '11-26-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.605486,
      NULL,
      3.852165,
      17.087526,
      2.523918,
      ' 6- 5-1989',
      0.974017,
      65,
      '10-27-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


