set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9700367';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '1',
      NULL,
      '4',
      '2',
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '2',
      '4',
      '4',
      '1',
      '2',
      '1',
      '2',
      '1',
      '1',
      '0',
      '4',
      '2',
      NULL,
      '',
      '1',
      '',
      '1',
      '3',
      '1',
      NULL,
      '0',
      '',
      NULL,
      '2',
      '1',
      '3',
      NULL,
      '3',
      '1',
      '1',
      '0',
      '2',
      NULL,
      '2',
      '023',
      '42220332',
      1.163694,
      21,
      '4212123',
      3,
      NULL,
      2,
      NULL,
      '244130',
      5,
      NULL,
      ' 5-15-1977',
      34.221703,
      NULL,
      38,
      9.377258,
      NULL,
      3.434717,
      NULL,
      3.037831,
      3,
      NULL,
      NULL,
      NULL,
      8.504677,
      0,
      5.174543,
      7.780974,
      9,
      13.011648,
      10.712937,
      3.442804,
      NULL,
      15,
      0.969096,
      4,
      0.608046,
      2,
      NULL,
      28,
      2.382034,
      165.341256,
      83.063841,
      ' 4- 8-1980',
      10,
      NULL,
      11,
      17,
      155.204340,
      56.897458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      101.570408,
      17,
      7.798851,
      7,
      3.045030,
      3.685567,
      NULL,
      NULL,
      NULL,
      102,
      NULL,
      0,
      73,
      1.232416,
      NULL,
      61.101206,
      NULL,
      NULL,
      NULL,
      ' 2-12-1989',
      70,
      45.321312,
      9,
      55.502016,
      0,
      NULL,
      43,
      16.989847,
      NULL,
      46,
      71.022667,
      30.751345,
      '11-15-1983',
      NULL,
      3.567697,
      9,
      8.040174,
      50,
      NULL,
      5.234021,
      ' 9- 2-1989',
      NULL,
      NULL,
      ' 6-29-1982',
      NULL,
      11.890019,
      11,
      0.422862,
      0,
      NULL,
      1,
      9,
      1,
      67.439666,
      3.734071,
      1.424289,
      3,
      16.622445,
      5.435580,
      1,
      0.238372,
      0.040219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      105.565463,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      30.819660,
      ' 1- 0-1993',
      NULL,
      ' 9-24-1986',
      6.208183,
      NULL,
      NULL,
      43,
      120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.430524,
      ' 4-27-1997',
      4.832040,
      NULL,
      28.114728,
      ' 6-18-1991',
      1.026412,
      89.821939,
      NULL,
      14.996652,
      12.581865,
      9.101324,
      NULL,
      '10- 9-1998',
      34.853402,
      0.150660,
      146,
      ' 2-13-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


