set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9700367';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '2',
      '3',
      '2',
      '3',
      '3',
      '4',
      '3',
      '2',
      '0',
      '2',
      NULL,
      '3',
      NULL,
      NULL,
      '1',
      '2',
      '2',
      '2',
      NULL,
      '3',
      '2',
      '2',
      '',
      '1',
      '',
      '1',
      '3',
      '4',
      '0',
      '3',
      '',
      NULL,
      '1',
      '3',
      NULL,
      '2',
      '2',
      '0',
      '1',
      '1',
      '1',
      '2',
      '2',
      '433',
      '41031144',
      54.074370,
      NULL,
      '4004032',
      0,
      10,
      NULL,
      1,
      '434001',
      NULL,
      NULL,
      NULL,
      208,
      30,
      28,
      2.271373,
      NULL,
      10,
      44,
      18,
      16,
      17.509386,
      NULL,
      10,
      NULL,
      5,
      26,
      3.511060,
      1,
      15.265191,
      NULL,
      0,
      27.390532,
      6.888401,
      32.325165,
      8,
      0.325963,
      105,
      72.202000,
      74.881000,
      168.650662,
      23.232794,
      196.034968,
      '11-12-1999',
      42,
      31,
      19.156847,
      33.289693,
      73,
      NULL,
      '10- 0-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743694,
      3,
      NULL,
      NULL,
      0.948240,
      3.186154,
      ' 2-14-2001',
      1,
      1,
      171.600849,
      1,
      1,
      130,
      NULL,
      0.565580,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-19-1997',
      88.876050,
      2,
      3,
      NULL,
      12.270282,
      53,
      67,
      103.734924,
      63.600109,
      108,
      3.623143,
      103.301329,
      '10- 3-1987',
      16,
      9,
      15.961066,
      NULL,
      NULL,
      43.154003,
      5.085718,
      ' 2-10-2001',
      NULL,
      12,
      ' 8- 9-1996',
      NULL,
      9,
      NULL,
      13.380834,
      8,
      NULL,
      1.635858,
      8.798380,
      0,
      NULL,
      1,
      0,
      NULL,
      3.196054,
      2.686987,
      NULL,
      1,
      NULL,
      ' 6- 6-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      20,
      ' 1- 9-1989',
      NULL,
      NULL,
      NULL,
      10,
      ' 5-27-1993',
      47,
      ' 5-11-1986',
      6,
      3,
      NULL,
      138.007247,
      10.206252,
      ' 6- 1-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      27,
      NULL,
      28.735684,
      ' 4- 6-1997',
      1.071276,
      83.550598,
      NULL,
      6.462355,
      107.014330,
      4,
      21,
      ' 3-12-1996',
      56,
      NULL,
      77,
      ' 6-26-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


