set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9674032';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '3',
      NULL,
      '4',
      '3',
      '3',
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '1',
      '0',
      '3',
      '0',
      NULL,
      '3',
      NULL,
      '3',
      '',
      '1',
      '',
      '3',
      '1',
      NULL,
      '4',
      '3',
      '',
      NULL,
      '2',
      NULL,
      '2',
      '0',
      '0',
      '4',
      '3',
      '4',
      '4',
      '0',
      '4',
      '230',
      '32',
      8.846083,
      10,
      '3201044',
      2.460332,
      1,
      NULL,
      NULL,
      '120044',
      2,
      NULL,
      ' 9-28-1998',
      NULL,
      9.447421,
      20.930825,
      21,
      31.513263,
      0,
      118.085355,
      21,
      9,
      NULL,
      36,
      14,
      8.926114,
      4.435734,
      20.559525,
      NULL,
      19.846843,
      NULL,
      34,
      2,
      37,
      3,
      10,
      8,
      1.727427,
      NULL,
      155,
      NULL,
      100,
      44.443329,
      82,
      ' 0-20-1988',
      71,
      NULL,
      27,
      23.661560,
      116.170223,
      210.566180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.919138,
      NULL,
      NULL,
      9,
      ' 2-18-2002',
      0.830775,
      1.166500,
      13.900262,
      2,
      1.053216,
      NULL,
      0.530554,
      1,
      45.609144,
      NULL,
      NULL,
      NULL,
      ' 2- 6-1983',
      NULL,
      4.924009,
      51,
      9.236075,
      69,
      NULL,
      NULL,
      8.348654,
      14,
      NULL,
      NULL,
      NULL,
      ' 6- 2-1974',
      7.301111,
      NULL,
      0,
      46,
      NULL,
      52.838842,
      11,
      ' 1-14-1991',
      NULL,
      8,
      '10- 2-1987',
      18.379750,
      NULL,
      NULL,
      NULL,
      19.906861,
      4.045649,
      1.183561,
      18,
      0.390597,
      NULL,
      0.514035,
      21,
      NULL,
      5.202297,
      5,
      1.266843,
      1.831598,
      0,
      ' 9- 0-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      170,
      6.002937,
      ' 6- 6-1987',
      NULL,
      NULL,
      NULL,
      61,
      '11-19-2000',
      35,
      ' 9- 0-1982',
      14,
      9.956760,
      ' 5-10-1980',
      35.262123,
      118,
      ' 3-26-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      ' 0- 0-1976',
      NULL,
      4.418122,
      41.418403,
      ' 3-11-1976',
      1,
      NULL,
      '10-11-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


