set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '4',
      '2',
      '2',
      '3',
      '0',
      '0',
      NULL,
      '2',
      NULL,
      '1',
      '4',
      '1',
      '0',
      '0',
      '1',
      '0',
      '3',
      '3',
      '2',
      '1',
      NULL,
      NULL,
      '',
      '1',
      NULL,
      '0',
      '2',
      NULL,
      '4',
      '4',
      NULL,
      '',
      '2',
      '0',
      '4',
      '4',
      '2',
      '1',
      '2',
      '3',
      '0',
      '0',
      NULL,
      '200',
      '14132001',
      79,
      NULL,
      '4104100',
      NULL,
      0.737391,
      1,
      NULL,
      '003342',
      5.164061,
      ' 6-18-2002',
      ' 1-20-1983',
      7.845091,
      41.676697,
      NULL,
      6.732294,
      13.521199,
      NULL,
      NULL,
      2.458761,
      17,
      14.546142,
      9,
      NULL,
      15.209073,
      NULL,
      NULL,
      7,
      4.636356,
      8.986919,
      NULL,
      0.773558,
      54.868488,
      11.749282,
      113.296159,
      15,
      0,
      88.933124,
      143,
      2.876992,
      171,
      NULL,
      30.354859,
      ' 9-12-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      6.200397,
      4.016351,
      ' 4- 5-1997',
      1.651690,
      1,
      NULL,
      1.566290,
      0,
      51.439899,
      1,
      NULL,
      49,
      NULL,
      NULL,
      NULL,
      ' 3-23-1982',
      51,
      52,
      10,
      NULL,
      74,
      32.077742,
      38,
      9,
      4,
      64,
      29.118609,
      60.317108,
      NULL,
      2.113115,
      NULL,
      8.266014,
      27,
      43.380513,
      NULL,
      4,
      ' 2-17-1975',
      5.001314,
      0.062941,
      ' 4-24-1979',
      9,
      4,
      NULL,
      18.559179,
      6,
      3,
      1,
      4,
      1,
      NULL,
      0.706060,
      1,
      17,
      19.248636,
      0.469517,
      1.272110,
      0,
      0,
      ' 8- 9-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      ' 7-26-1989',
      NULL,
      ' 9-16-1976',
      13.216143,
      NULL,
      ' 5-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      13,
      ' 8-19-1997',
      42.596475,
      7.449100,
      31,
      ' 4- 5-1982',
      0.446213,
      96,
      ' 9-20-1997',
      NULL,
      6.032893,
      14,
      12,
      ' 4-22-1989',
      NULL,
      0,
      67.804445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


