set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '0',
      '4',
      '3',
      '4',
      '1',
      '2',
      '1',
      NULL,
      '2',
      '4',
      '0',
      '0',
      '2',
      '1',
      '2',
      '0',
      NULL,
      '2',
      '0',
      '2',
      '3',
      '0',
      '',
      '4',
      '',
      '0',
      '2',
      '4',
      NULL,
      NULL,
      '',
      '',
      '0',
      NULL,
      '3',
      '0',
      NULL,
      '0',
      '4',
      NULL,
      '4',
      '1',
      '4',
      '421',
      NULL,
      21.989711,
      74.955691,
      '3023204',
      3.682174,
      20.728690,
      NULL,
      1,
      NULL,
      NULL,
      ' 4-11-1978',
      ' 7-23-2003',
      108,
      175.112706,
      5,
      NULL,
      NULL,
      NULL,
      53.578138,
      NULL,
      13.755674,
      6.526820,
      33.010452,
      5.915781,
      37,
      7,
      NULL,
      16,
      15,
      20,
      6,
      16,
      57,
      NULL,
      61.943793,
      19.079356,
      1,
      NULL,
      76.755881,
      110.646077,
      40,
      39.520510,
      160,
      ' 4-19-2003',
      34.565030,
      16,
      NULL,
      8.800897,
      NULL,
      216.761635,
      '10- 3-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      6,
      NULL,
      8.783372,
      3,
      5,
      ' 9-17-2000',
      1.512872,
      1.491970,
      156,
      2,
      NULL,
      167,
      1.906388,
      0.438032,
      40,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.859424,
      17,
      12,
      56.068042,
      72.638672,
      21.645438,
      97.746373,
      NULL,
      47.477913,
      30,
      52,
      ' 8-23-1975',
      20.938393,
      6.989478,
      5.177235,
      39.809298,
      42.097714,
      NULL,
      2,
      ' 6-15-1981',
      16,
      NULL,
      ' 4-14-1993',
      9,
      8.524676,
      NULL,
      NULL,
      17,
      13,
      0,
      19,
      1.360621,
      31,
      2.279141,
      0,
      NULL,
      5,
      1,
      1,
      0,
      0,
      ' 0- 3-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      26.486441,
      ' 5-26-1999',
      NULL,
      NULL,
      NULL,
      18,
      '11-27-1977',
      28,
      ' 0-11-1985',
      NULL,
      16,
      ' 3-25-1993',
      NULL,
      113.405865,
      ' 9-28-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      16.705308,
      '11- 1-1981',
      NULL,
      42.743188,
      12,
      '11-21-2000',
      0,
      87,
      ' 0-14-2002',
      NULL,
      1.568328,
      15,
      46,
      ' 1-29-1986',
      37.486208,
      1,
      39.239547,
      ' 3-26-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


