set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '0',
      '2',
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      '0',
      NULL,
      '3',
      '0',
      '3',
      '4',
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      '',
      NULL,
      '',
      '3',
      '3',
      '1',
      '4',
      '0',
      NULL,
      '',
      '1',
      NULL,
      '4',
      '4',
      '0',
      '2',
      '3',
      NULL,
      '3',
      '2',
      '2',
      '343',
      '02',
      46,
      NULL,
      '2440034',
      3.587104,
      0.872298,
      3,
      NULL,
      '203434',
      0.524475,
      ' 8-11-2002',
      ' 2-23-2001',
      NULL,
      93.804224,
      30.853154,
      6,
      12,
      3.415552,
      27.938881,
      5,
      12.463233,
      1.687321,
      NULL,
      2,
      31.676446,
      20.487244,
      31.571558,
      10.651634,
      3.249432,
      11.507482,
      NULL,
      5,
      25.068475,
      9,
      123,
      0.752590,
      NULL,
      61,
      170.661137,
      41,
      86,
      13,
      160.449361,
      ' 1- 3-1983',
      NULL,
      NULL,
      28,
      10.519218,
      NULL,
      NULL,
      ' 5-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.246908,
      38.370163,
      4.898334,
      NULL,
      3.626773,
      1,
      ' 8- 1-2003',
      1,
      3.091005,
      203,
      3.409141,
      0.901931,
      NULL,
      1.878990,
      0,
      46,
      NULL,
      NULL,
      NULL,
      '10-17-1982',
      35,
      20.950330,
      7,
      15.261524,
      47.763977,
      0.521949,
      41.790856,
      57,
      1.475221,
      13.815477,
      33,
      86.078455,
      NULL,
      NULL,
      2,
      6,
      11.454948,
      NULL,
      NULL,
      2,
      ' 0- 5-1991',
      NULL,
      17.306381,
      ' 7-28-1987',
      5,
      12.902110,
      7.044128,
      22,
      25,
      1.857276,
      1,
      1,
      0,
      2,
      1,
      0.066483,
      23,
      8.028765,
      0.206635,
      1,
      1.217325,
      NULL,
      ' 7-23-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      116,
      40,
      ' 4- 3-2001',
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      17.062353,
      ' 6-19-1981',
      7.101998,
      11,
      ' 6-20-1997',
      NULL,
      86,
      ' 6- 6-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      15.821399,
      ' 5- 7-1994',
      37.234235,
      11,
      30.822951,
      ' 4-27-2002',
      1.270578,
      NULL,
      ' 5-11-1993',
      NULL,
      12,
      5.260332,
      15.539211,
      ' 8- 8-1991',
      60.898624,
      0.204978,
      33.164252,
      ' 2- 4-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


