set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      '0',
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      '1',
      '3',
      '0',
      NULL,
      '3',
      '4',
      '2',
      '1',
      '0',
      '1',
      '3',
      '0',
      NULL,
      '1',
      '',
      '3',
      '',
      '2',
      NULL,
      '1',
      '3',
      '2',
      '',
      '',
      NULL,
      '1',
      '3',
      '4',
      '0',
      '1',
      '3',
      '2',
      '3',
      '0',
      NULL,
      '412',
      '02221413',
      NULL,
      53.898466,
      NULL,
      3.851639,
      7,
      2,
      NULL,
      '310011',
      4.084897,
      '10- 3-1978',
      ' 0-25-1993',
      NULL,
      NULL,
      NULL,
      19.220341,
      14,
      1,
      21,
      6.424842,
      8,
      13.899717,
      21.739112,
      7,
      31,
      NULL,
      NULL,
      29.796783,
      13,
      5.317844,
      NULL,
      1.315082,
      2,
      5.265084,
      47.856719,
      18,
      3,
      39,
      112.725083,
      16.069345,
      111.508822,
      NULL,
      104,
      ' 4- 1-1993',
      NULL,
      NULL,
      31.853982,
      1,
      26.579989,
      93.973405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      8.780397,
      1.405847,
      25,
      23.162647,
      1,
      ' 4- 6-1976',
      0.002045,
      NULL,
      102,
      0.026656,
      1,
      168.657727,
      1,
      1,
      79,
      NULL,
      NULL,
      NULL,
      ' 6-22-1984',
      24,
      2,
      22,
      40,
      0.535851,
      41.570378,
      15,
      44,
      NULL,
      8.231910,
      13.344174,
      NULL,
      ' 1- 7-1996',
      26,
      13,
      11,
      81.703032,
      97.812882,
      11.091692,
      4,
      ' 7-19-1993',
      NULL,
      24.983886,
      ' 0-14-1979',
      13.092692,
      NULL,
      10,
      7.130285,
      0.868986,
      3.408209,
      NULL,
      19,
      0.760607,
      113,
      0.345162,
      0.873669,
      1,
      2,
      NULL,
      NULL,
      0.147831,
      0.875189,
      '10-26-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      ' 4- 6-1987',
      NULL,
      NULL,
      NULL,
      24,
      ' 6- 2-2002',
      18,
      ' 4-24-1983',
      12,
      5,
      ' 0- 0-1994',
      124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      19,
      NULL,
      56,
      38,
      18.147341,
      ' 9- 2-1984',
      0,
      73,
      ' 0-29-1988',
      2,
      3,
      NULL,
      33.342753,
      ' 3-15-1998',
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


