set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8716657';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34221423',
      '12330324',
      '13212414',
      '42303114',
      '03033213',
      NULL,
      '43003010',
      '42411420',
      '42423444',
      '24401422',
      '23404014',
      '23321133',
      NULL,
      '00011113',
      '34414030',
      NULL,
      '14000343',
      NULL,
      '44041402',
      NULL,
      NULL,
      '12423230',
      NULL,
      '13400411',
      '34314010',
      NULL,
      '33130234',
      '22222221',
      NULL,
      '32203231',
      NULL,
      '01433213',
      '04004112',
      '31020004',
      '02121321',
      '14422102',
      '40231201',
      NULL,
      NULL,
      '22400011',
      '24313412',
      NULL,
      NULL,
      '24411404',
      NULL,
      '24',
      NULL,
      NULL,
      '2443002',
      1,
      NULL,
      1,
      NULL,
      '120320',
      0.096344,
      NULL,
      '10-21-1982',
      125,
      NULL,
      10,
      1,
      5,
      13.217719,
      48.066472,
      NULL,
      NULL,
      19,
      5,
      9.942378,
      11,
      20,
      NULL,
      NULL,
      NULL,
      39,
      37.479519,
      NULL,
      33.539789,
      NULL,
      98.146474,
      13,
      0.460474,
      50.180040,
      NULL,
      70.305458,
      203.748302,
      NULL,
      87,
      NULL,
      NULL,
      20.853818,
      29,
      26,
      147.299288,
      113.367495,
      ' 7- 3-1977',
      0.127432,
      0.505646,
      0.528807,
      2.897386,
      5,
      1.694311,
      1.075381,
      NULL,
      1.489451,
      0,
      NULL,
      1,
      0.499578,
      3.918356,
      1.391432,
      1.739645,
      4,
      0,
      0.763300,
      0.484665,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-29-1990',
      NULL,
      NULL,
      11,
      0.483803,
      3,
      NULL,
      ' 2-22-1977',
      1.001295,
      NULL,
      251.310296,
      0.752106,
      2,
      96,
      2.074487,
      0.934425,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 0-1980',
      115,
      82.665576,
      91,
      48,
      59.369321,
      97.009962,
      15.606814,
      NULL,
      NULL,
      84,
      21,
      74,
      '10- 3-2003',
      24.976892,
      7,
      22,
      61,
      13.287526,
      144,
      3,
      NULL,
      NULL,
      2,
      ' 6-24-1999',
      NULL,
      15.074669,
      7.763100,
      7.763567,
      14.629830,
      7,
      1,
      NULL,
      NULL,
      14.174733,
      0,
      1,
      2.156306,
      0.912614,
      NULL,
      2,
      NULL,
      NULL,
      ' 1-17-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      62.981464,
      5,
      ' 8-15-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      ' 1- 1-1987',
      4.827371,
      1.578628,
      ' 3- 8-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      ' 4-24-1994',
      27,
      27,
      3.124712,
      ' 7- 0-1985',
      1.928065,
      37,
      ' 0- 7-2002',
      11.059782,
      7.506657,
      15,
      NULL,
      NULL,
      55.767461,
      NULL,
      108,
      ' 4- 3-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


