set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8716657';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1313',
      '24244313',
      NULL,
      '44212033',
      '33420323',
      '24321444',
      '11220042',
      '01024431',
      '04322212',
      '23412324',
      '42211004',
      '01201134',
      '22124121',
      '24222110',
      '31111342',
      '41104140',
      '22422402',
      '42030200',
      '31223100',
      '20424012',
      '31123412',
      '02220040',
      '01044444',
      '32031440',
      '41122000',
      '40403342',
      NULL,
      NULL,
      '22410243',
      NULL,
      NULL,
      '12421220',
      '30111032',
      NULL,
      NULL,
      NULL,
      '14044422',
      '03300423',
      '01120044',
      '21122133',
      '43331012',
      '42404102',
      '12030302',
      '02013403',
      '43344033',
      '433',
      '23',
      29,
      9.529102,
      '2023001',
      3,
      25.396538,
      3,
      NULL,
      '340330',
      4,
      ' 5-15-1999',
      ' 3-29-1993',
      112,
      111.630724,
      9.146914,
      17,
      6,
      20,
      NULL,
      6,
      15,
      17.175296,
      NULL,
      5.992062,
      27.474892,
      10.508795,
      32,
      7,
      NULL,
      24,
      4.747060,
      5.333423,
      50,
      15,
      158.742606,
      28,
      NULL,
      22.599068,
      NULL,
      16.731269,
      52,
      17.171774,
      135,
      ' 8-15-1979',
      54,
      22.814121,
      27,
      16.539446,
      NULL,
      202.648673,
      ' 6-25-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.128995,
      18.705639,
      7,
      12.934454,
      4,
      ' 3- 6-1978',
      0.593228,
      0,
      NULL,
      1.850710,
      0,
      84,
      NULL,
      0,
      21.265674,
      NULL,
      NULL,
      NULL,
      NULL,
      73.368835,
      29,
      42.739343,
      77.922054,
      73.171787,
      NULL,
      24.922920,
      NULL,
      89.948646,
      NULL,
      NULL,
      NULL,
      ' 5-27-1989',
      13.889151,
      NULL,
      17,
      NULL,
      3,
      23,
      11,
      '10-13-1995',
      NULL,
      12.608634,
      ' 9- 0-1976',
      12,
      NULL,
      2.463785,
      3.170826,
      6,
      1,
      1,
      14,
      1,
      66,
      1,
      0.594860,
      3.285397,
      NULL,
      NULL,
      0,
      1.608870,
      0.577714,
      ' 2- 4-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      NULL,
      ' 3-27-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-20-2000',
      NULL,
      ' 2-18-2000',
      4,
      17,
      ' 4- 4-2003',
      144.545116,
      82,
      ' 4- 9-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      31,
      ' 5- 4-1992',
      0,
      25,
      41.252247,
      ' 6-23-2000',
      NULL,
      NULL,
      ' 8- 9-2001',
      5.075922,
      8,
      NULL,
      17,
      ' 2- 4-1997',
      NULL,
      1.941168,
      152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


