set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9404475';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33441141',
      '34023330',
      '31441234',
      '42310011',
      NULL,
      '41103420',
      '34441021',
      '02231013',
      '24322122',
      '34421240',
      '00403012',
      '02143430',
      '14030014',
      '21122311',
      '21402203',
      '00114431',
      '21344041',
      '10131101',
      '03131243',
      NULL,
      '03022221',
      NULL,
      NULL,
      NULL,
      '22301014',
      '04122140',
      '31400241',
      '23224322',
      '40300313',
      '22333123',
      NULL,
      '23432110',
      '03421344',
      '04424103',
      '04213032',
      '20420432',
      '23122341',
      '30201201',
      '03033234',
      NULL,
      '01121032',
      '12221243',
      '20224123',
      '32344004',
      '140',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1.241482,
      ' 2-16-1988',
      NULL,
      11,
      NULL,
      3,
      16,
      NULL,
      2,
      NULL,
      7.490227,
      17,
      5,
      6.348278,
      14.343529,
      13.186909,
      2.088100,
      14.093362,
      8.358934,
      2.982916,
      4.700815,
      21.888583,
      NULL,
      30.790242,
      16.713390,
      98.980613,
      4.546535,
      0,
      69,
      104,
      NULL,
      99.613299,
      151,
      8.817819,
      NULL,
      49.743157,
      64.656975,
      25.393909,
      31.042360,
      59.059937,
      170,
      ' 4-13-1987',
      1.517121,
      16.049240,
      3.386360,
      70.412895,
      NULL,
      14,
      3,
      6.936460,
      0.883660,
      1,
      3,
      1,
      0,
      26.080082,
      0.551734,
      0,
      32.653967,
      2.626087,
      NULL,
      18.821676,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-18-1976',
      25.549652,
      12,
      2.474585,
      9.284185,
      NULL,
      7,
      ' 3-26-1992',
      1.436263,
      0,
      112,
      0,
      2.911131,
      2,
      0.522998,
      1.999953,
      44.224632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      38.284586,
      NULL,
      65.982922,
      19,
      46.538247,
      54.086289,
      7,
      NULL,
      ' 0-10-2001',
      20.246263,
      12.638825,
      19.280341,
      41,
      39,
      19,
      7,
      ' 6-21-1992',
      NULL,
      2,
      NULL,
      0,
      0.891025,
      11.925904,
      5.680653,
      6.254032,
      3.741784,
      1.418758,
      3,
      0.710639,
      NULL,
      1.409412,
      NULL,
      4.883802,
      15.427876,
      NULL,
      0.380662,
      NULL,
      NULL,
      ' 7-29-1975',
      NULL,
      2.610040,
      0.656373,
      NULL,
      96,
      NULL,
      ' 6- 3-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 9-2000',
      5,
      NULL,
      9,
      14,
      ' 8-23-1995',
      58.562395,
      98.895659,
      ' 0-28-2000',
      4,
      2.843123,
      ' 6-11-1976',
      NULL,
      NULL,
      NULL,
      1,
      1,
      16,
      ' 4-26-1998',
      66.929206,
      23,
      8,
      NULL,
      0.225173,
      56.971781,
      NULL,
      5.658938,
      12.489934,
      21.921011,
      32.325758,
      ' 8- 3-2001',
      4.897331,
      0.574563,
      71.983514,
      ' 3-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14);
commit;
end;
/


