set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9741362';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '1',
      '2',
      '1',
      NULL,
      '1',
      NULL,
      '3',
      NULL,
      '1',
      NULL,
      NULL,
      '2',
      '3',
      '4',
      '2',
      '0',
      NULL,
      '4',
      '2',
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      '',
      '1',
      '4',
      '4',
      '0',
      '4',
      '',
      '',
      '3',
      '1',
      '0',
      '3',
      NULL,
      '3',
      NULL,
      '3',
      NULL,
      NULL,
      '0',
      '321',
      NULL,
      NULL,
      18.149365,
      NULL,
      1,
      0,
      3,
      NULL,
      '102343',
      0,
      ' 6-20-1982',
      ' 8-19-1985',
      155.355087,
      7,
      5.416803,
      13,
      NULL,
      12.821552,
      NULL,
      5.238718,
      14,
      NULL,
      35,
      6.029760,
      30,
      11,
      2,
      1.340156,
      4,
      17,
      92,
      5,
      NULL,
      6,
      61.969997,
      11,
      0,
      NULL,
      211.660875,
      NULL,
      20.450967,
      124.005283,
      90.256586,
      ' 2- 0-1978',
      NULL,
      70.941138,
      NULL,
      21,
      NULL,
      114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      92.503496,
      17.810920,
      17.783362,
      5.093843,
      10,
      2,
      ' 8-17-1993',
      1,
      NULL,
      222.300291,
      NULL,
      1.164747,
      148,
      0,
      0.241185,
      70,
      NULL,
      NULL,
      NULL,
      ' 7- 9-1974',
      NULL,
      39.318073,
      105,
      78,
      45.983694,
      91,
      88,
      76,
      50,
      0,
      60.004338,
      69.888325,
      '11- 5-2001',
      27,
      31,
      NULL,
      77,
      56,
      22.723818,
      NULL,
      ' 5-28-1992',
      9.114703,
      16,
      '11-16-1992',
      6,
      7,
      16,
      2,
      22,
      3.934026,
      0,
      0,
      1,
      92.913716,
      3.958751,
      1,
      NULL,
      4.427577,
      1,
      0.132684,
      3.724308,
      0,
      ' 4-20-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      83.710882,
      2.371630,
      '10- 9-1998',
      NULL,
      NULL,
      NULL,
      41.382961,
      NULL,
      24,
      '10- 5-1998',
      7,
      13,
      ' 1-29-1982',
      142.787990,
      39,
      ' 8-11-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      10.952625,
      NULL,
      NULL,
      51.282970,
      52.868631,
      ' 3-24-1997',
      1.586420,
      NULL,
      ' 0-26-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


