set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0101654';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '0',
      '4',
      '2',
      '1',
      '0',
      '2',
      NULL,
      NULL,
      '4',
      NULL,
      '2',
      '1',
      NULL,
      '4',
      '2',
      NULL,
      '2',
      '4',
      '1',
      '0',
      '2',
      '3',
      '',
      NULL,
      NULL,
      '4',
      NULL,
      '2',
      '3',
      NULL,
      '',
      NULL,
      '0',
      NULL,
      '0',
      '1',
      '2',
      '3',
      '0',
      '1',
      NULL,
      '3',
      '1',
      '220',
      '44420223',
      NULL,
      27.718558,
      '1011230',
      3,
      1.313423,
      1,
      NULL,
      '410142',
      2,
      ' 3-29-1996',
      ' 5-23-1983',
      29.726674,
      196,
      NULL,
      NULL,
      6.509554,
      14,
      50.877550,
      3,
      0.110939,
      6.719390,
      10,
      8,
      NULL,
      14.943467,
      NULL,
      3.348889,
      NULL,
      8.423813,
      14.206359,
      4.040077,
      23.616962,
      6.450829,
      55,
      6.891525,
      0.623932,
      32.466108,
      20,
      41,
      149.224549,
      NULL,
      33,
      ' 0-16-1991',
      33,
      NULL,
      NULL,
      4,
      169.231607,
      128,
      ' 9-26-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      89.603155,
      1.196805,
      3.405547,
      5,
      NULL,
      6.314758,
      ' 5-23-1989',
      0.626790,
      NULL,
      190.802361,
      0.958031,
      1,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-24-1984',
      86.079432,
      106.773514,
      74,
      53,
      36.301944,
      NULL,
      NULL,
      53.454676,
      92.057198,
      2.140154,
      24,
      31.246922,
      '10-26-1997',
      4,
      8,
      2.549790,
      30,
      33,
      NULL,
      1.130853,
      NULL,
      7.650230,
      NULL,
      ' 8-14-2000',
      8.241495,
      12.348340,
      2,
      3.954360,
      NULL,
      2,
      NULL,
      15,
      0.111474,
      89,
      0,
      1.146974,
      11.737303,
      16.156011,
      NULL,
      2.457049,
      0.129709,
      1,
      ' 2-23-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      '11-10-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-11-1996',
      11.471624,
      '11-17-2002',
      10.070669,
      8,
      ' 8-15-1995',
      NULL,
      49.523246,
      ' 6-26-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      21,
      '11- 5-1978',
      3.782016,
      27,
      4.176334,
      ' 2- 4-2002',
      0.322473,
      86.832153,
      ' 6- 6-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


