set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9732872';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      '2',
      '3',
      '3',
      '2',
      NULL,
      '1',
      '3',
      '4',
      '3',
      '4',
      NULL,
      '4',
      '0',
      '4',
      '4',
      '1',
      '4',
      '0',
      '4',
      '3',
      '3',
      '4',
      '',
      '4',
      NULL,
      '3',
      '1',
      NULL,
      '2',
      NULL,
      '',
      '',
      '2',
      '3',
      '1',
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '14202011',
      24,
      27.202168,
      '3421120',
      1.143497,
      0.767606,
      3,
      NULL,
      '023231',
      2,
      ' 8-21-2003',
      ' 1-29-1978',
      95,
      15,
      30,
      2,
      6,
      7,
      80.010088,
      2,
      7,
      12,
      15.801297,
      0.503070,
      NULL,
      15,
      11,
      24,
      NULL,
      14,
      15,
      3.481160,
      22,
      3,
      80,
      16,
      2.137535,
      3.490555,
      31.281660,
      47.122249,
      NULL,
      12,
      157,
      ' 1-24-1985',
      43.299391,
      8,
      13.649121,
      37,
      155,
      193,
      ' 4- 6-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      8,
      0.110816,
      1.391852,
      NULL,
      0.769807,
      NULL,
      96.055519,
      1.794553,
      0,
      94.536085,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-24-2000',
      28,
      82,
      NULL,
      2,
      105,
      42.092131,
      NULL,
      NULL,
      NULL,
      8.595721,
      80,
      49.399038,
      ' 2-19-1992',
      2,
      2,
      22,
      10.553213,
      1.307487,
      34.086607,
      NULL,
      NULL,
      23,
      12.969250,
      '11-22-1977',
      13,
      2,
      NULL,
      19,
      24.614355,
      7.340092,
      0,
      14.438150,
      0.333567,
      52.728394,
      NULL,
      NULL,
      21.190746,
      9.572576,
      1.799526,
      0.988097,
      NULL,
      1.082895,
      ' 6-26-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      110,
      22,
      '11-18-1997',
      NULL,
      NULL,
      NULL,
      5.299067,
      ' 5-28-2001',
      29.463870,
      ' 2- 5-1987',
      11.945126,
      9.349928,
      '10-17-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.511651,
      NULL,
      27.019456,
      5.484271,
      12,
      ' 3- 9-1992',
      1,
      13,
      ' 8-20-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


