set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4614445';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3431',
      '10313010',
      NULL,
      '21140302',
      '13322002',
      NULL,
      NULL,
      '04024421',
      NULL,
      '40222001',
      '23230142',
      NULL,
      '32424232',
      '13042024',
      '30430223',
      '01311043',
      '34410244',
      '32130124',
      '12341434',
      '40203222',
      '23103030',
      NULL,
      '00124230',
      '03112332',
      '21012120',
      '22410313',
      NULL,
      '10430424',
      NULL,
      '11441133',
      '32333132',
      '10310114',
      NULL,
      NULL,
      '00034422',
      '23033412',
      '34334302',
      NULL,
      '24112303',
      '30420042',
      '14323234',
      '14114000',
      '04224412',
      '33230103',
      '14040432',
      '',
      '',
      NULL,
      NULL,
      '3334342',
      3.631693,
      1,
      0,
      NULL,
      '402002',
      0,
      ' 9- 2-1987',
      NULL,
      94.353205,
      NULL,
      19.449035,
      NULL,
      21.214073,
      8.827663,
      40.909256,
      12.991956,
      16.681936,
      9.808177,
      36,
      0.206239,
      NULL,
      21,
      10,
      9,
      5,
      5,
      NULL,
      NULL,
      47.129573,
      2,
      NULL,
      0,
      NULL,
      32.532473,
      95,
      NULL,
      169.443377,
      134,
      98,
      ' 2-16-1981',
      52,
      16,
      19,
      NULL,
      112,
      189,
      '11-15-1981',
      NULL,
      9.932604,
      1.829538,
      5.151994,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747139,
      1,
      1,
      0,
      1,
      6.223612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-17-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-19-1975',
      NULL,
      16.297587,
      109.078074,
      12,
      74.942937,
      95.871179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-22-1994',
      5.090959,
      NULL,
      20,
      102.494082,
      NULL,
      0.516229,
      1,
      ' 5-11-1996',
      37.629434,
      30.433412,
      NULL,
      1,
      21.732164,
      5.484823,
      13.936708,
      7,
      7.765047,
      NULL,
      15,
      NULL,
      100,
      0,
      5,
      11.238766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      11,
      NULL,
      ' 5- 4-1999',
      1.619654,
      123.116666,
      ' 6-15-1991',
      6,
      10.346011,
      12,
      NULL,
      ' 5-16-1974',
      44.646603,
      1.350184,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      80,
      NULL,
      4.998330,
      94,
      119.929302,
      NULL,
      7,
      44.970927,
      35.577299,
      2,
      4,
      0,
      5.690105,
      7,
      1,
      1,
      NULL,
      NULL,
      3,
      67,
      1,
      0,
      149,
      21.956092,
      NULL,
      18,
      0,
      NULL,
      1,
      1,
      0,
      1.836351,
      0,
      1.250681,
      72,
      13,
      NULL,
      19,
      106,
      120,
      NULL,
      0,
      13.002034,
      1,
      24.173528,
      0.511911,
      19.615925,
      0,
      63,
      4.001075,
      NULL,
      NULL,
      3.252197,
      112.066664,
      18.381749,
      6.970938,
      8,
      58.533664,
      100.579168,
      3.454161,
      65,
      2,
      10,
      3.644915,
      5,
      1.390801,
      0,
      2,
      NULL,
      27.442768,
      ' 9-12-2002',
      ' 4-29-2000',
      NULL,
      ' 2- 6-2001',
      NULL,
      '10- 8-1998',
      '10- 7-1988',
      NULL);
commit;
end;
/


