set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815085';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4110',
      '23202412',
      '20432224',
      '41032332',
      '41331020',
      '32241142',
      '43431332',
      NULL,
      '00000020',
      '12420324',
      '31243413',
      '41044323',
      NULL,
      NULL,
      '42023220',
      '30123442',
      '43211101',
      '21301012',
      '00142104',
      '21421231',
      '20132043',
      '31113123',
      '04244340',
      '04341310',
      '03021323',
      '44010014',
      '33123110',
      '24432024',
      '12120101',
      '30323133',
      '33410430',
      '13104034',
      '24420341',
      '01214412',
      '03101343',
      '10031141',
      '03234113',
      '30243111',
      '22443013',
      NULL,
      '03102441',
      '04433443',
      '21110214',
      '20404311',
      '01244012',
      NULL,
      '',
      NULL,
      NULL,
      '0323043',
      0,
      1.959445,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      44.534789,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      59.480076,
      NULL,
      0.072348,
      8,
      10,
      2,
      0.474184,
      3,
      0,
      5,
      12,
      12,
      7.002398,
      1,
      25.511830,
      1,
      55,
      0.028176,
      NULL,
      61.794226,
      NULL,
      31,
      101.033326,
      37,
      91.604202,
      NULL,
      NULL,
      17,
      23.445185,
      NULL,
      127,
      131,
      NULL,
      0.249705,
      3.433254,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.783860,
      NULL,
      0,
      3,
      0.412815,
      3.743786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      24,
      7,
      59.953269,
      NULL,
      0,
      61,
      60.021664,
      89,
      53.046969,
      NULL,
      0.751007,
      7.493493,
      10.631822,
      20,
      6,
      1,
      2,
      NULL,
      2,
      1.619427,
      NULL,
      4,
      7.687415,
      10,
      NULL,
      3,
      2.286431,
      NULL,
      NULL,
      NULL,
      8,
      1.300025,
      1.479687,
      6.013508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      223,
      NULL,
      4,
      353.696113,
      NULL,
      127,
      NULL,
      47,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49.181217,
      6,
      4.650831,
      NULL,
      43,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      19.310192,
      NULL,
      0.044096,
      85.899209,
      1.707893,
      NULL,
      92,
      1.178478,
      NULL,
      NULL,
      NULL,
      24.050919,
      NULL,
      NULL,
      97.382978,
      0,
      1,
      1,
      1,
      0.564250,
      1,
      89,
      36,
      53.468762,
      2,
      36.128632,
      10.779702,
      2.110596,
      1.821329,
      0.217659,
      0,
      NULL,
      0.278308,
      1.665133,
      0.645152,
      23.840395,
      1,
      97,
      1.323070,
      1.833493,
      62.188343,
      0.013548,
      NULL,
      10.474860,
      90.372884,
      NULL,
      5,
      33.462352,
      2,
      0,
      3,
      4.814555,
      2.297572,
      NULL,
      4,
      2,
      26.960287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


