set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9823126';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '1',
      '0',
      '1',
      '0',
      '1',
      '2',
      '4',
      '1',
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '0',
      '3',
      '1',
      '2',
      '2',
      '0',
      '3',
      '3',
      '3',
      '',
      NULL,
      '',
      NULL,
      '3',
      '0',
      '2',
      '4',
      '',
      '',
      '4',
      '1',
      '2',
      '2',
      '0',
      NULL,
      '0',
      '2',
      NULL,
      '0',
      '3',
      '141',
      NULL,
      62.156459,
      59.176233,
      '4113220',
      1.188691,
      1.041773,
      1,
      NULL,
      '333434',
      3.090067,
      ' 5-27-2003',
      ' 0- 6-1978',
      NULL,
      57.204864,
      18.599080,
      NULL,
      14.028388,
      8.528760,
      44,
      7,
      23.865029,
      5.436889,
      29.271096,
      1.699624,
      NULL,
      1,
      16,
      14,
      NULL,
      15,
      36.312615,
      NULL,
      5,
      1,
      79.653822,
      2.650249,
      0,
      NULL,
      41.356457,
      24.651709,
      87,
      117.802176,
      66.911701,
      ' 2-22-1989',
      37,
      NULL,
      22.520235,
      26,
      188,
      NULL,
      ' 3-14-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.797964,
      15,
      4,
      7,
      3.367220,
      3.865632,
      NULL,
      NULL,
      0.337907,
      98.990515,
      NULL,
      1,
      30.504676,
      NULL,
      0,
      51.491361,
      NULL,
      NULL,
      NULL,
      ' 9- 8-1980',
      24.307739,
      NULL,
      7.199612,
      70,
      NULL,
      54,
      NULL,
      50.379981,
      NULL,
      3,
      8.949122,
      37.021175,
      ' 7-13-1995',
      NULL,
      6,
      8.053621,
      NULL,
      42.750276,
      171,
      1.995399,
      ' 8-26-1982',
      21,
      18,
      ' 9-16-2000',
      7.184518,
      8.692582,
      NULL,
      4,
      13,
      2,
      1,
      10.718727,
      1,
      37,
      0,
      NULL,
      10,
      22.622081,
      2,
      0.918799,
      0,
      0,
      ' 8- 0-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      3.674740,
      3.127265,
      ' 2- 5-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 4-1986',
      0.482421,
      NULL,
      NULL,
      16,
      '10- 5-2003',
      36,
      91,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      20.027630,
      ' 8-26-1985',
      26.106177,
      14.194484,
      NULL,
      '10-23-1981',
      1.858360,
      111,
      '10-15-1999',
      8,
      9.972394,
      NULL,
      48,
      NULL,
      68,
      NULL,
      45,
      ' 9- 7-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


