set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9823126';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '3',
      '2',
      NULL,
      '4',
      '2',
      '4',
      '4',
      '2',
      '0',
      '2',
      '0',
      '0',
      '1',
      '4',
      '4',
      '4',
      NULL,
      '4',
      NULL,
      '0',
      '1',
      '2',
      '',
      '2',
      '',
      '4',
      NULL,
      '3',
      '0',
      '1',
      '',
      '',
      '2',
      NULL,
      '0',
      NULL,
      '2',
      '4',
      NULL,
      '3',
      '2',
      '1',
      '0',
      '103',
      '40201321',
      22,
      2,
      '0433131',
      2,
      49,
      NULL,
      NULL,
      '030411',
      2.148621,
      ' 6-26-1996',
      ' 3-27-1974',
      NULL,
      102,
      6,
      12.658600,
      NULL,
      22,
      33.876505,
      3.027239,
      25,
      2.236819,
      19,
      NULL,
      NULL,
      6,
      NULL,
      0,
      20,
      8.691437,
      33,
      0.628807,
      57,
      17,
      13,
      7.060322,
      NULL,
      54.735841,
      200,
      6,
      164,
      192,
      NULL,
      NULL,
      47.651054,
      14.105331,
      13,
      22.542346,
      166.205638,
      143.310611,
      ' 8-23-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      9.542832,
      5.170126,
      5.241572,
      NULL,
      0.550092,
      ' 8-15-1976',
      1,
      1.137396,
      10,
      NULL,
      0,
      NULL,
      0.775537,
      0.655556,
      9,
      NULL,
      NULL,
      NULL,
      ' 7-19-1975',
      7,
      NULL,
      56.468172,
      NULL,
      65,
      65.924098,
      NULL,
      NULL,
      75,
      87.974910,
      2.760668,
      56.678526,
      NULL,
      21.363636,
      NULL,
      NULL,
      3,
      49.892352,
      NULL,
      9,
      ' 5- 4-2003',
      14,
      NULL,
      '11-20-1999',
      4.463317,
      5,
      NULL,
      NULL,
      NULL,
      11,
      0,
      9,
      0.006851,
      41,
      1,
      0.609522,
      1.825481,
      2,
      0,
      0.667346,
      NULL,
      1,
      ' 9-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      147,
      0,
      ' 8-27-2001',
      NULL,
      NULL,
      NULL,
      14.356626,
      ' 2-17-1997',
      38,
      ' 5-11-1986',
      6.370077,
      NULL,
      '10-18-1991',
      112.971604,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      23.437321,
      '10-14-1990',
      20,
      24.264675,
      21,
      NULL,
      NULL,
      41,
      ' 8-24-1979',
      14.272936,
      14,
      4,
      6,
      ' 4-16-1997',
      61,
      0,
      121,
      '11- 6-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


