set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226537';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4202',
      '41211131',
      '43011121',
      '03124034',
      NULL,
      '43323402',
      '42211144',
      '01014020',
      '03300400',
      '31101412',
      '02010322',
      '13142411',
      '32002224',
      NULL,
      '31130113',
      '44103214',
      '22411312',
      NULL,
      '33222021',
      '20441042',
      '44410203',
      NULL,
      '41221012',
      '32431012',
      '23434120',
      '32042342',
      '30433230',
      '34102214',
      NULL,
      '41103131',
      NULL,
      '40212024',
      '44431142',
      NULL,
      '14221341',
      '30242242',
      '12121340',
      '24023040',
      '21203114',
      NULL,
      '01330034',
      '44423003',
      '04024422',
      '20332123',
      '11134300',
      NULL,
      '11',
      NULL,
      NULL,
      '2244301',
      0,
      0.370031,
      2,
      NULL,
      '312241',
      4,
      ' 6- 0-1993',
      NULL,
      20,
      NULL,
      10,
      15,
      0,
      6,
      NULL,
      6.595861,
      11,
      11,
      NULL,
      11,
      8,
      2,
      2.416763,
      7,
      8,
      3.497239,
      26,
      2.898658,
      13.907392,
      9,
      NULL,
      5.887722,
      1,
      96,
      NULL,
      24,
      95,
      117.292957,
      NULL,
      ' 1-25-1981',
      46.493599,
      32,
      21,
      31.901975,
      4,
      187,
      ' 2-29-1996',
      3,
      0,
      NULL,
      3.910907,
      0.634323,
      3.296154,
      1,
      2.881094,
      1.480737,
      0,
      0,
      0.673199,
      0,
      NULL,
      0,
      NULL,
      3,
      1.816794,
      0.308590,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-11-1998',
      21,
      43.790024,
      2,
      0.659116,
      24,
      5.120281,
      NULL,
      0,
      0.172827,
      28,
      0.068145,
      1,
      8.010009,
      1,
      5,
      66,
      1.685695,
      0,
      159,
      ' 7- 7-1978',
      NULL,
      77.413790,
      11,
      25.700619,
      131,
      0.687292,
      92.906995,
      77.953541,
      NULL,
      98.416462,
      95,
      26,
      NULL,
      11.410814,
      8,
      7.399096,
      NULL,
      3.268485,
      7,
      7,
      '11- 4-1986',
      NULL,
      0.193873,
      ' 5- 0-1996',
      3.618970,
      NULL,
      NULL,
      2,
      9,
      0,
      1,
      6.526096,
      NULL,
      50,
      3.438115,
      1.340583,
      NULL,
      15,
      NULL,
      2,
      7,
      3.988012,
      ' 6-27-2001',
      NULL,
      1,
      1,
      ' 4-17-1978',
      NULL,
      2,
      ' 1-26-1987',
      NULL,
      NULL,
      NULL,
      26.295978,
      '11-24-2001',
      32.814261,
      ' 1-10-1978',
      NULL,
      5,
      ' 0-23-1984',
      NULL,
      NULL,
      ' 9- 5-2001',
      9.929009,
      5.228368,
      ' 1-24-1980',
      1,
      11.994091,
      ' 0- 1-2002',
      0,
      3,
      11,
      ' 4-19-1976',
      32,
      28.781649,
      26,
      ' 2-13-1992',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      ' 5-15-1993',
      NULL,
      0.654911,
      31,
      ' 4-11-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949716);
commit;
end;
/


