set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9012810';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0432',
      '40001113',
      NULL,
      NULL,
      '31312303',
      NULL,
      '11434042',
      '34144422',
      '11343411',
      NULL,
      '34413234',
      '30230443',
      '44301314',
      '00131320',
      '03333403',
      NULL,
      '03334031',
      '24113441',
      '13423310',
      '43231310',
      NULL,
      '31413034',
      '30313114',
      NULL,
      '11412210',
      '40002420',
      '04022140',
      '32000044',
      NULL,
      '20222323',
      NULL,
      '30223220',
      NULL,
      '11330311',
      '34401310',
      '01000332',
      '24002341',
      '31243404',
      '20343113',
      '24003220',
      '13041213',
      '12203034',
      NULL,
      '23114101',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      2.256853,
      1,
      2,
      NULL,
      '432121',
      NULL,
      ' 7-28-1991',
      ' 4- 6-1987',
      0.761584,
      NULL,
      NULL,
      6.036178,
      1,
      9.349373,
      42.189630,
      5,
      10,
      NULL,
      NULL,
      3.110246,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      35.122100,
      3.273558,
      1.954036,
      2,
      1.503197,
      1.858378,
      NULL,
      57.863249,
      153.437143,
      3.762915,
      19,
      45.253703,
      91,
      ' 7- 4-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.033139,
      1.392446,
      1.177030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.708004,
      NULL,
      NULL,
      3.428886,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-10-1974',
      92.086340,
      90,
      NULL,
      67.835597,
      33,
      13.433616,
      46.981670,
      NULL,
      11,
      NULL,
      NULL,
      20,
      '10- 9-1979',
      0.131468,
      12.004104,
      7.217218,
      3,
      5,
      3.303989,
      4,
      ' 6-13-1982',
      8.840942,
      1,
      ' 2- 5-1977',
      NULL,
      3,
      0,
      3,
      3.705470,
      3.728655,
      NULL,
      7,
      NULL,
      NULL,
      7,
      16.190442,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-21-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43.065122,
      10,
      1.250191,
      ' 6-22-1980',
      NULL,
      130.243664,
      ' 6-15-1988',
      4,
      20,
      NULL,
      27,
      ' 5-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78.853161,
      35.655757,
      22.059819,
      68,
      18.204984,
      NULL,
      1.039415,
      128,
      NULL,
      23,
      1.710725,
      1.141150,
      136.492333,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      101.068773,
      NULL,
      NULL,
      393,
      17.242397,
      21.473461,
      NULL,
      1,
      28.912301,
      1.128113,
      0.044679,
      1,
      5.537881,
      NULL,
      1.272011,
      29,
      0.475095,
      NULL,
      1.526163,
      15.200227,
      NULL,
      1.920513,
      2,
      18,
      1,
      NULL,
      NULL,
      NULL,
      1.143180,
      21,
      3,
      NULL,
      0.294510,
      0,
      26,
      0.763249,
      NULL,
      NULL,
      33.278082,
      15,
      13,
      11,
      2,
      8.552582,
      3.617466,
      17.674100,
      3.705602,
      4,
      NULL,
      1.447469,
      NULL,
      ' 7- 3-2001',
      NULL,
      ' 9- 7-1982',
      ' 8-23-1992',
      '10-18-1987',
      ' 3-12-2002',
      ' 1-19-1974',
      NULL);
commit;
end;
/


