set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2333',
      '31233131',
      '21104013',
      '34023201',
      '24120404',
      '41422214',
      NULL,
      '23401212',
      '44010443',
      '13201000',
      '12420120',
      '14302020',
      NULL,
      '13344142',
      NULL,
      NULL,
      '31203420',
      '43243023',
      '40114140',
      NULL,
      '40141243',
      '30312244',
      '04034214',
      NULL,
      '41120242',
      '01123243',
      '10033201',
      '33013301',
      NULL,
      '30414322',
      NULL,
      '10124220',
      '20134042',
      NULL,
      '32411110',
      '00200112',
      NULL,
      '43001043',
      '10323334',
      '20033141',
      NULL,
      '14140143',
      '43330113',
      '41430031',
      '44314410',
      '022',
      '14',
      18.594595,
      8.771802,
      NULL,
      2.593715,
      0.271034,
      3,
      NULL,
      NULL,
      NULL,
      '10-11-2001',
      '11-10-1994',
      88.136434,
      85,
      NULL,
      NULL,
      16,
      5.534670,
      47,
      7.840334,
      20,
      13.953816,
      6,
      NULL,
      NULL,
      18,
      29,
      15,
      14.269440,
      0,
      50.237974,
      6.224288,
      27.616894,
      11,
      6,
      8,
      0.676895,
      40.686942,
      21.245150,
      NULL,
      41.258967,
      177.037130,
      78.014517,
      NULL,
      36,
      5,
      NULL,
      18.199441,
      145,
      159,
      ' 3-24-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      16,
      7,
      5.185325,
      0,
      ' 0-12-1988',
      0.149767,
      NULL,
      146.936942,
      0.969753,
      NULL,
      52.287121,
      0.168413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-12-1984',
      NULL,
      30.363783,
      3,
      34,
      83.318014,
      NULL,
      61.831332,
      23,
      7.710416,
      NULL,
      45.906823,
      60,
      NULL,
      13,
      5.813450,
      21.480776,
      NULL,
      32,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      120.053585,
      1.358470,
      '10-22-1978',
      NULL,
      NULL,
      NULL,
      39.426735,
      NULL,
      11.267335,
      '10-16-1986',
      6.886825,
      NULL,
      ' 0-23-1995',
      61.544642,
      1,
      ' 6- 2-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      15,
      ' 7- 6-1982',
      51.001657,
      28,
      18.342349,
      '11- 2-1978',
      NULL,
      NULL,
      NULL,
      3.841315,
      78.349182,
      5,
      19,
      ' 9-22-1993',
      9.560732,
      1,
      118.103798,
      ' 7-19-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


