set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4010',
      '34221441',
      '41230002',
      '31131243',
      '10302200',
      '41023221',
      '21414430',
      '01024122',
      '21334044',
      '01424330',
      '43334330',
      NULL,
      '31130200',
      '24311120',
      '01334012',
      '23410034',
      '44144023',
      '31021104',
      '14010104',
      '12412432',
      '03442142',
      '43311410',
      '04141010',
      '23424003',
      '34134232',
      '02123301',
      '41122142',
      '33130102',
      '44131114',
      '13204311',
      '14333130',
      '00313321',
      '10312142',
      '03040411',
      '00314244',
      '12131333',
      NULL,
      '23141314',
      NULL,
      '42140234',
      '32324212',
      '13013044',
      NULL,
      '31322424',
      '00322342',
      '330',
      '44',
      14,
      13,
      '4441134',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      ' 1-12-1985',
      NULL,
      67,
      78,
      19,
      4.755270,
      9.598833,
      8,
      50,
      19.054302,
      5,
      7,
      1,
      5.281384,
      29.817586,
      NULL,
      16.123897,
      22.758334,
      16,
      14,
      42.250262,
      15,
      NULL,
      4,
      50,
      5.944065,
      0.531291,
      114,
      72.630501,
      NULL,
      84,
      98,
      167,
      '11-24-2000',
      NULL,
      6,
      19,
      4,
      86.216356,
      172,
      ' 7-11-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      25.881140,
      6.762247,
      NULL,
      19,
      1.954816,
      ' 3- 9-1986',
      0,
      1,
      122.934349,
      1,
      1,
      22,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 0-1980',
      75,
      29,
      0,
      34.282845,
      NULL,
      50.166922,
      12.229717,
      35.243916,
      29,
      68,
      37.169933,
      54.239362,
      ' 4-25-1985',
      NULL,
      20.874529,
      16,
      NULL,
      7,
      35,
      10.167800,
      ' 3-24-1984',
      13,
      28,
      ' 9- 7-1983',
      1,
      1,
      9,
      NULL,
      NULL,
      3.108316,
      2.520160,
      12.610449,
      0.440104,
      25,
      2,
      NULL,
      13.884580,
      11,
      1.415910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      197,
      9,
      ' 4-18-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.472947,
      ' 6-23-1995',
      8.076073,
      1.763272,
      ' 5- 3-1988',
      13,
      13,
      ' 2-25-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      9.151954,
      NULL,
      NULL,
      21,
      31.398165,
      ' 5-10-1983',
      0.813244,
      NULL,
      NULL,
      3,
      83,
      10,
      27,
      ' 3-13-1994',
      55.356080,
      NULL,
      114.751661,
      '11- 2-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


