set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '0',
      '3',
      '0',
      '4',
      '1',
      '0',
      '3',
      '0',
      '3',
      '1',
      NULL,
      '2',
      '0',
      '4',
      '0',
      '4',
      '2',
      '3',
      '1',
      NULL,
      '2',
      '1',
      '',
      '3',
      '',
      '2',
      '4',
      '2',
      '2',
      '3',
      '',
      NULL,
      '1',
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '1',
      '4',
      '0',
      '3',
      '4',
      '100',
      '02432131',
      29.384800,
      38.429024,
      '2330314',
      NULL,
      113,
      NULL,
      NULL,
      '222302',
      2,
      ' 3-25-2001',
      ' 8-28-1981',
      NULL,
      46.647178,
      13.794043,
      3.454442,
      6,
      13,
      66.648827,
      3.226094,
      NULL,
      23.606465,
      NULL,
      17,
      3.092039,
      7,
      1,
      20,
      4,
      27,
      11.099008,
      16.389183,
      53.725651,
      5,
      NULL,
      13,
      1,
      81,
      33,
      20.545744,
      NULL,
      60.083985,
      176.488171,
      ' 3-15-1977',
      20,
      35,
      7,
      12.745434,
      148.584615,
      NULL,
      ' 5-11-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.942591,
      NULL,
      8.482345,
      13.689199,
      1,
      4,
      ' 1- 4-1984',
      1,
      1,
      26.952641,
      0.525645,
      1.840661,
      60.089715,
      NULL,
      1,
      52.272035,
      NULL,
      NULL,
      NULL,
      ' 1-19-1987',
      84.759700,
      NULL,
      NULL,
      10,
      14,
      32,
      37,
      84,
      NULL,
      61,
      NULL,
      NULL,
      ' 6-27-1990',
      25,
      NULL,
      19,
      NULL,
      40.583816,
      NULL,
      0,
      ' 3- 7-2001',
      20.855470,
      NULL,
      '11- 4-1997',
      7.895298,
      7,
      7.756741,
      11.916331,
      NULL,
      3,
      1.962566,
      2,
      0.050520,
      1,
      1,
      0,
      5,
      25,
      0.536773,
      0.255908,
      1.201734,
      NULL,
      '10-18-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      100.512557,
      10,
      ' 6-13-2003',
      NULL,
      NULL,
      NULL,
      60.909800,
      ' 0- 0-2003',
      10,
      ' 0-18-1996',
      8.547431,
      8.241696,
      '11-10-1978',
      118.195198,
      57,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.307230,
      ' 9- 0-1979',
      31.771914,
      NULL,
      NULL,
      ' 7-13-1997',
      NULL,
      167,
      ' 6-13-1975',
      1,
      11,
      13.034253,
      NULL,
      NULL,
      29.571016,
      1,
      16,
      ' 9-27-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


