set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8634195';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0311',
      NULL,
      '21130313',
      '31101401',
      NULL,
      '12123403',
      '32020111',
      '12222042',
      '30212131',
      '31042042',
      '30404120',
      '04021102',
      '41042424',
      '20401322',
      '41404402',
      NULL,
      NULL,
      NULL,
      '32123143',
      NULL,
      '22121100',
      '01211342',
      '23211004',
      '32324121',
      '44303422',
      '03302224',
      '31142122',
      '31112441',
      '23302234',
      '22412340',
      '22420413',
      NULL,
      '33304341',
      '41013033',
      NULL,
      '34241223',
      NULL,
      '23004024',
      '33010141',
      '01030000',
      '33012030',
      '44242401',
      NULL,
      '12213003',
      '31001441',
      '331',
      '43',
      NULL,
      NULL,
      '3444002',
      0,
      0,
      1,
      NULL,
      NULL,
      0.569600,
      ' 5-17-1984',
      NULL,
      77,
      NULL,
      NULL,
      6.000934,
      NULL,
      NULL,
      49.319983,
      NULL,
      27,
      14.629162,
      NULL,
      17.748024,
      NULL,
      0.690716,
      24,
      6,
      13.775200,
      2,
      5.999969,
      9.668154,
      NULL,
      19.800231,
      131,
      21.420753,
      1,
      53.053228,
      31,
      25,
      229,
      123,
      88.996431,
      ' 7- 8-2002',
      9.821240,
      55.243936,
      14.010200,
      20,
      NULL,
      NULL,
      ' 5-29-1979',
      1.215315,
      0,
      3,
      0,
      1,
      1,
      NULL,
      0.369484,
      1.551922,
      NULL,
      1.852267,
      1,
      NULL,
      0.061546,
      1.395648,
      0.387285,
      1,
      1.151953,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 5-1999',
      49.112444,
      4,
      4,
      1.047822,
      5.434199,
      10,
      ' 0- 9-1997',
      1.921317,
      1,
      NULL,
      0,
      0,
      13,
      NULL,
      1,
      NULL,
      NULL,
      1,
      103,
      NULL,
      NULL,
      42.835764,
      19,
      88,
      120,
      76.991357,
      52.485835,
      12.856290,
      29.130707,
      77,
      108,
      20.571201,
      NULL,
      28.852639,
      3.358896,
      NULL,
      43,
      81.964131,
      NULL,
      1,
      ' 0-16-1992',
      12.581660,
      NULL,
      ' 4- 2-1985',
      15,
      15.019525,
      29.530833,
      16.716678,
      4,
      7,
      0,
      4,
      NULL,
      54.548769,
      1,
      1,
      8.658828,
      NULL,
      1,
      NULL,
      0.727328,
      1.223799,
      ' 6-25-1992',
      NULL,
      3,
      0.181730,
      NULL,
      21,
      6,
      '11- 2-1974',
      21,
      NULL,
      ' 9-17-1992',
      NULL,
      ' 7-24-1981',
      41,
      ' 7-19-1988',
      NULL,
      4,
      NULL,
      89,
      NULL,
      NULL,
      4.374453,
      10.414130,
      ' 6- 1-1984',
      2,
      17.827611,
      ' 9-25-1989',
      0,
      1,
      23.368459,
      NULL,
      33.330186,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4);
commit;
end;
/


