set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14120422',
      NULL,
      '11113200',
      '11234240',
      '33023204',
      '12100040',
      '20234320',
      '01211442',
      NULL,
      '42334212',
      '30343310',
      NULL,
      '14433413',
      '10214043',
      '41124001',
      NULL,
      '02013110',
      '11040022',
      '33203023',
      '23024432',
      '10023040',
      '12443214',
      '30411303',
      '44302402',
      '30334131',
      '24204330',
      '20221334',
      '42422243',
      NULL,
      '31131142',
      '01122124',
      '14240212',
      NULL,
      '30304333',
      '42441034',
      '12112321',
      '04422321',
      '23432300',
      NULL,
      NULL,
      '14421143',
      '14013213',
      '03224411',
      '32433121',
      '',
      '',
      NULL,
      NULL,
      '0101110',
      NULL,
      0,
      NULL,
      NULL,
      '020332',
      0,
      ' 1- 0-2003',
      ' 7-16-1984',
      69,
      NULL,
      2,
      9,
      21,
      10.943995,
      0,
      5.113932,
      NULL,
      NULL,
      13.754596,
      NULL,
      0,
      0.206525,
      3.033327,
      NULL,
      4.382918,
      NULL,
      41.386899,
      NULL,
      0.908705,
      9,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      50.680125,
      154.296006,
      11.403465,
      16.473506,
      '10-27-1994',
      NULL,
      2.025089,
      7,
      22.688553,
      138.237476,
      160,
      ' 4-15-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.400628,
      9,
      NULL,
      8,
      1,
      0.437871,
      ' 8-15-1991',
      NULL,
      NULL,
      NULL,
      5.376655,
      7,
      13,
      NULL,
      10,
      NULL,
      NULL,
      7,
      NULL,
      3.623898,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644450,
      149.808234,
      NULL,
      12.992623,
      69,
      10.668357,
      138.896535,
      '10-19-1991',
      18,
      0,
      61,
      ' 3-24-1986',
      NULL,
      NULL,
      NULL,
      42,
      NULL,
      NULL,
      NULL,
      51,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.466981,
      1.590817,
      0,
      NULL,
      NULL,
      3,
      39.700886,
      NULL,
      26.192126,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.810533,
      5.059982,
      NULL,
      7,
      7.794297,
      49.452808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-12-1987',
      ' 3-29-1978',
      NULL,
      ' 7-11-1998',
      NULL,
      NULL,
      NULL);
commit;
end;
/


