set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4202',
      '41442210',
      NULL,
      '04313414',
      '23424141',
      '34024404',
      '24001334',
      '44241223',
      '01443033',
      '02440210',
      '24232411',
      '01003402',
      '21244130',
      '12400121',
      '34034110',
      '44030443',
      '42032422',
      '40400312',
      '42343221',
      '13311121',
      '03212313',
      '12323141',
      '32323223',
      '03310043',
      NULL,
      '22201444',
      NULL,
      '30321211',
      '13410333',
      NULL,
      '32030333',
      NULL,
      '10432431',
      '30031022',
      '03124443',
      NULL,
      '13320002',
      '23312203',
      '40342132',
      '03142343',
      '22012144',
      NULL,
      '02441240',
      '14110013',
      '33234413',
      '',
      '',
      NULL,
      NULL,
      '3102123',
      NULL,
      44,
      0,
      NULL,
      '131424',
      0.057605,
      ' 1-24-1979',
      ' 3-11-1984',
      1.718306,
      NULL,
      9.464185,
      3,
      NULL,
      16,
      4,
      2.645001,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      NULL,
      NULL,
      89,
      3.000425,
      NULL,
      NULL,
      NULL,
      NULL,
      141,
      NULL,
      120,
      '11- 9-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141977,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.596589,
      7.728198,
      0,
      1,
      9.275921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-15-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-19-1976',
      NULL,
      NULL,
      61.528376,
      42.058254,
      115.793675,
      28.787887,
      43.777786,
      2,
      22.285279,
      112.660837,
      11,
      110.427052,
      '10- 6-1975',
      NULL,
      2,
      6,
      31.755329,
      57.279604,
      NULL,
      9.257931,
      ' 3-29-2000',
      1,
      2.592067,
      '10-18-1985',
      7,
      0.416337,
      0.977291,
      14,
      NULL,
      NULL,
      NULL,
      16.306292,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-23-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      5.468532,
      3,
      ' 1- 0-2002',
      5,
      171,
      ' 3- 0-1992',
      4,
      27,
      NULL,
      NULL,
      ' 6-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      2.079113,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359101,
      1,
      NULL,
      1.391407,
      0.770288,
      8.133796,
      NULL,
      0.617683,
      100.513983,
      48.904587,
      NULL,
      14,
      51.483566,
      NULL,
      NULL,
      0.282351,
      54,
      6,
      1.208506,
      1.545084,
      4.494251,
      1.033539,
      0.966598,
      11.195974,
      42.719527,
      NULL,
      NULL,
      NULL,
      16.636651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222182,
      45.871057,
      0,
      0.905163,
      73,
      21,
      2.243228,
      2.339708,
      26,
      NULL,
      NULL,
      NULL,
      0.640756,
      NULL,
      1.570263,
      9,
      0,
      1.908875,
      1,
      NULL,
      19.025381,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-15-1989',
      NULL,
      ' 8- 6-1984',
      NULL);
commit;
end;
/


