set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4221',
      '21234341',
      '04310244',
      '32104242',
      '40320110',
      '00401421',
      '23224230',
      '24440322',
      NULL,
      NULL,
      '24113432',
      '44412340',
      '31024322',
      '10432044',
      '20423144',
      '11143220',
      '04130431',
      '23303002',
      '32411102',
      '40020414',
      '14440211',
      NULL,
      '34042334',
      '42300231',
      NULL,
      '13240011',
      '01434022',
      '03011442',
      '11221302',
      '34134142',
      '12020334',
      NULL,
      '34144410',
      '34021330',
      '20410232',
      NULL,
      '10124434',
      '44112241',
      '40213014',
      '42031021',
      '20431011',
      NULL,
      '01330043',
      '23343322',
      '04001000',
      '421',
      '30',
      NULL,
      NULL,
      '2430313',
      NULL,
      NULL,
      1,
      NULL,
      '020414',
      NULL,
      ' 3- 5-1986',
      ' 2- 0-1986',
      29,
      NULL,
      1.044607,
      1,
      8.533325,
      7.571801,
      5,
      7,
      7,
      3,
      18,
      12.136442,
      29,
      9,
      3.698493,
      16,
      5,
      7,
      6,
      7.660582,
      2.794000,
      NULL,
      28,
      9,
      0,
      61,
      82.073102,
      NULL,
      99,
      125.246902,
      139.970831,
      ' 7-27-2003',
      NULL,
      7,
      16.931032,
      NULL,
      141.072070,
      165,
      ' 5- 3-1979',
      0,
      5.834413,
      0,
      6,
      0.050278,
      3,
      5,
      NULL,
      NULL,
      1,
      1.374633,
      0.674228,
      0,
      7.575325,
      1.114881,
      0.538353,
      7.831075,
      0,
      1.568389,
      5.482687,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-28-1986',
      11,
      47.067739,
      19.536726,
      28.119425,
      NULL,
      1.096924,
      ' 9-18-1997',
      1,
      1,
      48,
      NULL,
      NULL,
      73,
      1.206490,
      1.497583,
      16.304041,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      82.076719,
      24.528513,
      NULL,
      67.028177,
      99.522308,
      74.424773,
      113,
      NULL,
      28.429882,
      76,
      61.461651,
      ' 2- 2-1993',
      12.473520,
      11,
      NULL,
      NULL,
      0.927076,
      3.997782,
      NULL,
      ' 8-21-2001',
      8,
      5.541141,
      ' 6-19-1999',
      4.730857,
      6,
      2,
      15,
      8.265834,
      4,
      0,
      4,
      0.110901,
      42,
      5.012532,
      6,
      4,
      NULL,
      5,
      11.635147,
      3,
      NULL,
      ' 5-20-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      39.884178,
      NULL,
      ' 2- 9-1989',
      NULL,
      NULL,
      NULL,
      23.173194,
      ' 1-10-1999',
      NULL,
      ' 1-12-1989',
      NULL,
      3,
      ' 4-23-1983',
      83,
      NULL,
      NULL,
      NULL,
      1.476054,
      ' 4- 8-1998',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.704458,
      ' 4-15-1986',
      NULL,
      NULL,
      8.641362,
      ' 8- 4-1999',
      7,
      133,
      ' 7-15-1994',
      7.572070,
      0,
      2,
      22,
      ' 3-11-1987',
      54.693207,
      0.982946,
      91,
      ' 0-27-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


