set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4034',
      NULL,
      '00031343',
      '10041300',
      '01442300',
      '13201434',
      '21334014',
      '11021003',
      NULL,
      '22313243',
      '22413033',
      '31002304',
      NULL,
      NULL,
      '23024024',
      '44432310',
      '30330144',
      '14434320',
      '40140101',
      '40143101',
      '33440422',
      '21404231',
      '31343120',
      '24343221',
      '00134011',
      '43114420',
      NULL,
      '20124332',
      '20000440',
      NULL,
      '14010304',
      '44210123',
      '04034404',
      '10312243',
      '33101144',
      '00440034',
      '32341104',
      '33231040',
      '10023130',
      NULL,
      NULL,
      '43034132',
      '02202213',
      '22413224',
      '03031430',
      '221',
      '03',
      34,
      1.032099,
      '3240020',
      NULL,
      44,
      0,
      NULL,
      '122301',
      NULL,
      ' 3-16-1988',
      ' 1-29-1978',
      21.228839,
      23,
      1,
      0,
      12.665854,
      NULL,
      12.350963,
      NULL,
      7,
      5.157509,
      3,
      NULL,
      5.140871,
      6.217837,
      0.766451,
      0,
      13.586280,
      3.863054,
      19,
      NULL,
      NULL,
      NULL,
      22.194353,
      8.569846,
      1.405475,
      42,
      50.115148,
      NULL,
      96.505068,
      105.771009,
      107.491473,
      NULL,
      5,
      13.021969,
      10,
      4,
      NULL,
      128.092458,
      '10-25-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74,
      8,
      NULL,
      2,
      ' 5- 2-1984',
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1.041348,
      NULL,
      86.580466,
      NULL,
      NULL,
      NULL,
      ' 4-19-1985',
      54,
      21,
      6,
      NULL,
      70,
      35,
      79,
      88.950814,
      45,
      69,
      NULL,
      34,
      NULL,
      9,
      1.433701,
      1,
      22.256459,
      11,
      1.773407,
      4,
      ' 6-11-1994',
      3,
      1,
      ' 6- 5-1995',
      8,
      NULL,
      8,
      3,
      5,
      1,
      NULL,
      3.152181,
      1.696886,
      NULL,
      1,
      7,
      3.587263,
      17.137920,
      5.050048,
      0,
      0,
      1,
      ' 2- 3-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.022117,
      ' 9-23-1983',
      18.221769,
      '11-14-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      6.400630,
      ' 7- 9-1998',
      3,
      20.617152,
      26.346623,
      ' 5-27-1994',
      0,
      224.865308,
      NULL,
      1,
      39.212940,
      12.379942,
      NULL,
      ' 7-29-1980',
      23.268211,
      0.590585,
      140,
      ' 4- 8-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


