set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      '2',
      NULL,
      NULL,
      '4',
      NULL,
      '1',
      '4',
      '3',
      '2',
      '1',
      '3',
      '4',
      '3',
      '1',
      '0',
      '0',
      '1',
      '0',
      '0',
      '4',
      '0',
      '',
      '0',
      '',
      NULL,
      '2',
      '0',
      '3',
      NULL,
      '',
      '',
      '0',
      '4',
      '1',
      '1',
      '2',
      '3',
      '0',
      '1',
      '1',
      '0',
      NULL,
      '212',
      '23321401',
      20.601813,
      62.367458,
      '3104043',
      NULL,
      47,
      3,
      NULL,
      '130131',
      5.009617,
      ' 7-13-1983',
      NULL,
      41,
      82,
      NULL,
      10.381620,
      11,
      4.511294,
      NULL,
      9.354237,
      6.216506,
      3.446568,
      NULL,
      1,
      21,
      NULL,
      21,
      NULL,
      5,
      2,
      15,
      NULL,
      14.337579,
      10.434037,
      46.215030,
      NULL,
      1,
      0,
      100,
      NULL,
      97.593682,
      26.968769,
      NULL,
      ' 2-28-1992',
      8.128037,
      14,
      0.997324,
      17.091093,
      76,
      154.484855,
      ' 8-29-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      18,
      25,
      5.018834,
      3.835816,
      ' 7-25-1992',
      1.501545,
      1,
      135,
      1.405412,
      1,
      92,
      3.164419,
      NULL,
      43,
      NULL,
      NULL,
      NULL,
      ' 0-10-1998',
      14.949929,
      29,
      22,
      27,
      38.042978,
      29,
      46.936512,
      7.431832,
      34.420359,
      38,
      44.741303,
      31,
      ' 1- 2-2002',
      3,
      3,
      9,
      NULL,
      10,
      0,
      3,
      ' 2-27-1975',
      1.818430,
      0.629072,
      NULL,
      9.622517,
      11,
      0,
      NULL,
      NULL,
      1.618637,
      3,
      2.862936,
      1,
      32,
      0.519647,
      1.372894,
      1,
      3,
      NULL,
      NULL,
      1.383615,
      1.170064,
      ' 9- 1-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      ' 8- 2-1974',
      17,
      ' 3-26-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4.825311,
      ' 4- 4-1974',
      13,
      8,
      NULL,
      ' 8-28-1984',
      7,
      232.438560,
      ' 6-18-2002',
      7.499715,
      9,
      17,
      13.439212,
      ' 8-22-1999',
      25.689471,
      0,
      178.000545,
      ' 2-20-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


