set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934076';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1214',
      '21011244',
      NULL,
      '03142301',
      '12031312',
      '03221440',
      '34113201',
      '11442302',
      '40421202',
      '31413414',
      NULL,
      NULL,
      '01230310',
      '24123143',
      '24231133',
      '41013023',
      '42123243',
      NULL,
      '40220424',
      '42022014',
      '41032401',
      NULL,
      '43044002',
      '24130303',
      '33310311',
      '21421342',
      '31340303',
      NULL,
      '23012100',
      '00242031',
      '20403042',
      '22112420',
      NULL,
      '21343410',
      NULL,
      NULL,
      '04110043',
      '34141312',
      '03013003',
      '24000000',
      '14024403',
      '12110341',
      '43102013',
      '03040330',
      '24002004',
      '403',
      NULL,
      NULL,
      NULL,
      '1340433',
      2.677180,
      NULL,
      3,
      NULL,
      NULL,
      2,
      ' 0-12-1980',
      ' 9-16-1998',
      8,
      NULL,
      7.996492,
      3,
      4,
      NULL,
      20.582962,
      0.041308,
      NULL,
      NULL,
      25.701420,
      12.447016,
      20,
      4,
      28,
      5,
      13,
      6.964315,
      31,
      NULL,
      51.880025,
      7.315865,
      3.179509,
      3,
      0,
      18.540590,
      NULL,
      47.534848,
      28.504858,
      NULL,
      45.531546,
      ' 2-23-1998',
      1.208808,
      3.800127,
      19,
      14,
      14.011683,
      NULL,
      '10- 2-1984',
      0.247234,
      2,
      3.712405,
      1,
      6,
      4,
      2,
      1,
      1.648661,
      0.954861,
      NULL,
      NULL,
      1.989892,
      0,
      1.116971,
      NULL,
      0.033709,
      1.733063,
      1.928629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      2.027728,
      2,
      '10-13-1983',
      1.131544,
      1,
      150.578176,
      3.988145,
      3.113494,
      71.396792,
      1,
      1.887299,
      70.779067,
      1.179319,
      1.139456,
      9,
      '11-28-2003',
      NULL,
      68.481348,
      4,
      NULL,
      35.334666,
      15,
      10.988802,
      52,
      23,
      38,
      NULL,
      39,
      ' 3- 8-1990',
      2.187206,
      17.142855,
      25,
      53,
      65,
      NULL,
      10.500828,
      '10- 4-1992',
      25,
      3,
      '10-29-1980',
      6,
      3,
      11.790713,
      12,
      2,
      NULL,
      0,
      10.262338,
      1.894104,
      77,
      0.865549,
      NULL,
      NULL,
      6.806787,
      NULL,
      13.037148,
      2.236517,
      3,
      ' 8-15-1989',
      0.160780,
      1.966968,
      NULL,
      ' 3-16-1995',
      30,
      15.595107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      ' 9-12-1985',
      7,
      11,
      ' 3- 8-2002',
      NULL,
      13.871315,
      ' 9-20-1993',
      NULL,
      NULL,
      ' 1-20-1976',
      3.993771,
      2.009150,
      '10-27-1977',
      1,
      3,
      2,
      ' 5-18-1987',
      7,
      NULL,
      15.099127,
      ' 0- 5-2003',
      NULL,
      191.032827,
      ' 2-11-2000',
      15.165640,
      41.333931,
      12,
      42,
      ' 2-17-1999',
      NULL,
      1.711867,
      44.236036,
      '11-20-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


