set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9824700';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '0',
      '4',
      '1',
      '2',
      '4',
      '2',
      '4',
      '2',
      '1',
      '2',
      '0',
      NULL,
      NULL,
      '3',
      '2',
      '0',
      '2',
      NULL,
      '3',
      NULL,
      '4',
      '3',
      '',
      '3',
      NULL,
      NULL,
      '4',
      '0',
      '1',
      '1',
      NULL,
      '',
      '2',
      '0',
      '3',
      '3',
      '2',
      NULL,
      '4',
      '3',
      '3',
      '2',
      '2',
      '221',
      '13142031',
      16.895532,
      11.858562,
      '3340001',
      0,
      NULL,
      2,
      NULL,
      '413103',
      3,
      ' 4-24-1985',
      ' 4-10-1994',
      77.827890,
      120,
      NULL,
      11,
      35,
      0.467853,
      48,
      NULL,
      12.111679,
      3.787524,
      23.693693,
      2.887224,
      NULL,
      19,
      5.355372,
      NULL,
      10.704851,
      19,
      NULL,
      16,
      NULL,
      NULL,
      2.188746,
      8.491926,
      0.533449,
      71.744988,
      183.522010,
      78,
      6.808225,
      181.595848,
      188.106665,
      ' 2- 8-2000',
      20.396035,
      23.530551,
      NULL,
      28,
      64.273985,
      56.838141,
      ' 9- 4-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.625212,
      2,
      4,
      11.052376,
      ' 4- 6-1975',
      1,
      1.386896,
      80.115776,
      0.279437,
      3,
      149,
      0,
      1.676715,
      104.717298,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      81.848062,
      87,
      56.310815,
      70,
      NULL,
      59.195450,
      21.690926,
      47,
      3.575181,
      62,
      15,
      ' 6- 1-1998',
      16.956318,
      17,
      9.668272,
      37,
      NULL,
      10,
      0,
      ' 9- 6-1988',
      18.033012,
      NULL,
      ' 2-10-1988',
      13.306904,
      15.881102,
      13.771121,
      6,
      12,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0.578119,
      8,
      NULL,
      NULL,
      0,
      NULL,
      0,
      ' 8- 8-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 1-15-1987',
      NULL,
      NULL,
      NULL,
      30,
      ' 4-22-1983',
      34,
      ' 5-24-1974',
      5,
      8.177537,
      ' 0-19-1978',
      85,
      36.239374,
      ' 5-14-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.131557,
      ' 0-24-1994',
      23.592515,
      NULL,
      31,
      '10-27-2000',
      1,
      129.775876,
      ' 2- 6-1989',
      2,
      5.773673,
      21,
      13,
      ' 4- 8-1996',
      0,
      1,
      83.414169,
      ' 1- 0-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


