set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9824700';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '3',
      '1',
      '2',
      '1',
      '3',
      NULL,
      '4',
      '0',
      NULL,
      '4',
      '3',
      '1',
      NULL,
      '0',
      NULL,
      '0',
      '2',
      '3',
      '0',
      '1',
      '2',
      '4',
      '',
      '4',
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      '2',
      '',
      '',
      '2',
      '3',
      NULL,
      '1',
      '1',
      '4',
      '3',
      '1',
      '1',
      '3',
      NULL,
      '242',
      '22020111',
      NULL,
      31.080601,
      '3102234',
      NULL,
      0,
      1,
      1,
      '232131',
      2.719283,
      ' 2- 7-1975',
      NULL,
      44.036154,
      83,
      45.394205,
      6.436191,
      33,
      22.281952,
      NULL,
      19.637008,
      13,
      16,
      NULL,
      2.221403,
      18,
      14,
      3,
      0,
      NULL,
      2,
      52.013673,
      2.232970,
      27,
      4,
      NULL,
      0.940091,
      0,
      60,
      56,
      80.868280,
      4.062711,
      NULL,
      NULL,
      '11- 4-1984',
      NULL,
      NULL,
      NULL,
      24.711868,
      28,
      30.485331,
      ' 6-20-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      72.047298,
      9.354082,
      4,
      NULL,
      4,
      2,
      '10- 4-1988',
      0.032786,
      2,
      NULL,
      1,
      1.111289,
      87,
      0.391059,
      3.479018,
      38,
      NULL,
      NULL,
      NULL,
      ' 5-14-1996',
      81,
      NULL,
      111.670628,
      NULL,
      37.137167,
      NULL,
      NULL,
      27,
      20,
      76,
      44.295474,
      49.985654,
      ' 2-10-1975',
      14,
      23.043246,
      15,
      NULL,
      29.615332,
      25,
      10.269941,
      ' 8- 3-1998',
      19.162226,
      1.665790,
      ' 6-27-1991',
      3.256250,
      4.429932,
      11.109687,
      NULL,
      NULL,
      4.557134,
      NULL,
      10,
      0,
      89,
      0.862971,
      0,
      4.232669,
      12,
      NULL,
      1,
      0.622417,
      1.426370,
      ' 0-28-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      15,
      '11-15-1996',
      NULL,
      NULL,
      NULL,
      47,
      ' 1-29-1984',
      14,
      ' 9-17-1974',
      16.894760,
      11.364519,
      ' 4- 1-1981',
      131,
      23.456260,
      '11- 9-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      13.396555,
      ' 9- 4-1997',
      26,
      34.890027,
      15.404494,
      ' 5-15-1991',
      3.289806,
      47.651266,
      NULL,
      15,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      1.913985,
      7.386216,
      ' 4-25-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


