set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9725689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3232',
      '14314014',
      '44421002',
      '11042404',
      '34213220',
      NULL,
      '02231133',
      '01133211',
      '31133300',
      '33232212',
      NULL,
      '41431300',
      '11403003',
      '31040104',
      '14033022',
      '02410213',
      '01432404',
      NULL,
      '24044024',
      NULL,
      '21431323',
      NULL,
      '41322242',
      '42232343',
      '31042123',
      '24122103',
      '22041110',
      '33012441',
      '42040120',
      NULL,
      '00120444',
      '23021241',
      '14113233',
      '21132210',
      NULL,
      '33422022',
      '40321234',
      '23140210',
      '34413343',
      NULL,
      '04004123',
      '34432142',
      '03440303',
      '13124103',
      '41243104',
      NULL,
      NULL,
      NULL,
      18,
      '4240213',
      NULL,
      1,
      0,
      NULL,
      '323143',
      NULL,
      NULL,
      NULL,
      80.040262,
      40,
      NULL,
      NULL,
      29,
      18,
      12,
      9.485614,
      29,
      15,
      NULL,
      9,
      34,
      0,
      23,
      2.158505,
      19,
      0,
      20.789496,
      12,
      61,
      9.612244,
      53,
      15,
      1,
      60,
      195,
      NULL,
      91.374753,
      174.969332,
      175,
      NULL,
      42,
      43.674323,
      2,
      20.421645,
      NULL,
      21,
      ' 1- 1-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      51.041713,
      NULL,
      25.847246,
      NULL,
      2.775524,
      ' 6- 3-1993',
      1.357145,
      0.995724,
      179,
      0,
      NULL,
      83,
      0.481025,
      3.723812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65,
      NULL,
      14.369386,
      41.990044,
      66,
      37.034084,
      80.206577,
      51,
      67,
      64,
      89.027805,
      42,
      NULL,
      18,
      NULL,
      25.443021,
      0.586874,
      72.480907,
      86,
      1.727896,
      '11- 7-1996',
      23,
      17,
      ' 2- 9-1995',
      17,
      7,
      21,
      7.754511,
      8,
      4.079355,
      0.655922,
      19,
      0.082645,
      NULL,
      4,
      7.012724,
      4.935439,
      14,
      1,
      1.938531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      2.945985,
      ' 8-23-1975',
      NULL,
      NULL,
      NULL,
      4,
      ' 3-28-1980',
      37.901284,
      NULL,
      6.849351,
      7,
      ' 5-24-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      13,
      ' 8- 3-1979',
      30.725781,
      16,
      18.153354,
      ' 3-12-1992',
      0.607586,
      87.330505,
      ' 7-19-1993',
      5.898533,
      18.050758,
      1.748491,
      NULL,
      ' 9-12-1974',
      30.126107,
      0,
      1,
      ' 7- 6-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


