set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7810402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2420',
      '01043314',
      '43223433',
      '42220401',
      '30213001',
      '11300211',
      '12333140',
      '42420440',
      '01432112',
      '23230002',
      '00433102',
      '30404131',
      '04140331',
      NULL,
      '00414104',
      '14231032',
      '42320101',
      '22030111',
      '30401140',
      '34103323',
      '11421423',
      '31234104',
      '31003402',
      '32133440',
      '32031002',
      '02301042',
      '42124211',
      '03421030',
      '23342332',
      '11222032',
      '10340031',
      '24040131',
      NULL,
      '30221102',
      '00340202',
      NULL,
      '34440212',
      '41022133',
      '32032402',
      '14204313',
      NULL,
      '30224122',
      '30241012',
      '32230004',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '0232420',
      2,
      NULL,
      0,
      NULL,
      '404130',
      NULL,
      ' 6-18-2002',
      '10-10-1987',
      NULL,
      NULL,
      16,
      NULL,
      11,
      1,
      62.562096,
      10.615616,
      NULL,
      NULL,
      21.365949,
      NULL,
      10,
      10,
      22,
      NULL,
      4,
      9,
      4,
      6,
      NULL,
      3.876115,
      19.942228,
      3.214830,
      NULL,
      34,
      NULL,
      29.325256,
      133,
      52,
      5,
      ' 2-12-1995',
      15,
      NULL,
      28,
      16.136734,
      71.524617,
      42,
      ' 7-11-1992',
      0,
      8,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.393303,
      0,
      NULL,
      NULL,
      0.556252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-21-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-13-1989',
      28,
      17,
      11,
      NULL,
      24,
      28,
      NULL,
      NULL,
      44.395374,
      19.982763,
      29.946631,
      30.189331,
      ' 6-26-1989',
      5.096849,
      1,
      1,
      1.431003,
      3,
      3,
      1.850867,
      ' 6-18-1984',
      6,
      9.974372,
      ' 0-28-1980',
      4,
      8.420893,
      0,
      4,
      10,
      1,
      NULL,
      0.156688,
      NULL,
      19.990762,
      4.452339,
      0.512829,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.889753,
      NULL,
      NULL,
      ' 1-19-1992',
      1.351122,
      843.853954,
      ' 7-16-1976',
      16,
      11,
      21.220024,
      168.854499,
      '10- 1-1989',
      47.472353,
      1,
      654.886905,
      ' 3-16-1997',
      NULL,
      NULL,
      NULL,
      43,
      NULL,
      32,
      30.361358,
      48.517272,
      137,
      30.689824,
      17,
      NULL,
      2,
      8,
      24.195929,
      1.923033,
      0.172368,
      178.559270,
      NULL,
      NULL,
      NULL,
      1.856268,
      NULL,
      70.779228,
      NULL,
      12.516142,
      385.868299,
      15.058652,
      3,
      12.137134,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      20.350501,
      45,
      6.054158,
      13,
      1.134501,
      19,
      1.285416,
      NULL,
      NULL,
      1,
      0.934879,
      1.027362,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      16,
      4,
      5,
      17.658576,
      27,
      NULL,
      NULL,
      NULL,
      22,
      14.358690,
      4,
      0,
      2,
      0,
      NULL,
      11,
      ' 4-14-2001',
      NULL,
      NULL,
      ' 2-11-1981',
      ' 0- 1-2001',
      ' 7- 8-1979',
      ' 7- 5-1976',
      NULL);
commit;
end;
/


