set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906739';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4101',
      '40323120',
      NULL,
      '12132111',
      '10132140',
      '41034404',
      '34111222',
      '21230040',
      NULL,
      '22033044',
      '41323424',
      '40242230',
      '04212430',
      NULL,
      '00310031',
      '40100420',
      '42022323',
      '22132400',
      '24130001',
      '24001113',
      '22433132',
      '31024240',
      '42111020',
      '44421322',
      '13214410',
      '04142334',
      '30431232',
      NULL,
      '43114101',
      '14334111',
      '20114300',
      '32100121',
      '04110120',
      '22142343',
      '23024130',
      NULL,
      '42111103',
      '12141002',
      '22040142',
      '04332123',
      '33440022',
      '04021220',
      '00434123',
      '13233202',
      '44321042',
      '',
      '',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      ' 1- 1-1993',
      NULL,
      1.330097,
      NULL,
      45.659124,
      3,
      NULL,
      10,
      NULL,
      16,
      24.761803,
      23,
      31.103240,
      6.447854,
      12.038276,
      4.416759,
      9,
      3.418368,
      8,
      17,
      33.638612,
      16,
      NULL,
      13,
      113.451535,
      5,
      NULL,
      130,
      231,
      52,
      NULL,
      182,
      15,
      ' 2-15-1989',
      5,
      20,
      13.853545,
      36,
      19.314768,
      214.197576,
      ' 1- 4-1980',
      1,
      0.705965,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.164043,
      1.629073,
      0,
      0.305260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 3-1994',
      NULL,
      93.216032,
      126,
      NULL,
      42,
      4,
      23.681018,
      109,
      NULL,
      102,
      NULL,
      109,
      '10-29-1997',
      14,
      23.488532,
      5,
      21.484012,
      NULL,
      21.048875,
      5.709840,
      NULL,
      0.206422,
      5,
      ' 1-11-1977',
      3,
      14,
      5.242898,
      10.580142,
      16.657092,
      0.804465,
      NULL,
      8.032133,
      NULL,
      29.976223,
      2.509798,
      0.363517,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 0-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      31.378669,
      ' 6-29-1996',
      1.643136,
      120.933542,
      NULL,
      17.856944,
      20,
      NULL,
      NULL,
      ' 6-14-1996',
      39.747687,
      NULL,
      135,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      1,
      0,
      36,
      17,
      61,
      48.943440,
      NULL,
      20,
      NULL,
      7.951005,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.536519,
      52,
      0.122740,
      7.188869,
      114.881404,
      5.923949,
      2.514413,
      131.680775,
      0.545106,
      24,
      120,
      1,
      NULL,
      1.773857,
      1,
      0,
      1,
      NULL,
      1.066132,
      11,
      33.287087,
      85.059377,
      2.694049,
      48.548355,
      63,
      0.288588,
      0.880350,
      35.404579,
      NULL,
      NULL,
      3,
      18.237287,
      1,
      47,
      NULL,
      38.764616,
      1.951830,
      0,
      7.070530,
      29.464735,
      14,
      5,
      81.962554,
      NULL,
      0,
      6,
      1,
      2.676882,
      1,
      NULL,
      0.053633,
      3,
      0,
      0,
      26,
      ' 0-16-1985',
      NULL,
      ' 7-16-1998',
      ' 5-13-1996',
      NULL,
      NULL,
      ' 1-15-1993',
      NULL);
commit;
end;
/


