set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215949';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4123',
      NULL,
      '20212311',
      '20033110',
      '22012103',
      NULL,
      NULL,
      NULL,
      '42214212',
      '03240141',
      '33322130',
      '33341024',
      '42203202',
      '14221334',
      '33433321',
      '24304121',
      '21244314',
      '12203403',
      '01113304',
      '33440140',
      '03333443',
      '22212400',
      '00111003',
      '13212001',
      '20013023',
      '43204133',
      '40202303',
      '01421130',
      '23042020',
      '40043313',
      '24314221',
      '40441340',
      '42422110',
      '00243130',
      NULL,
      '40041120',
      '22400201',
      NULL,
      NULL,
      '31323300',
      '13010224',
      '03421323',
      '11134113',
      NULL,
      NULL,
      '030',
      '32',
      NULL,
      NULL,
      '4234421',
      2.761361,
      1,
      3,
      NULL,
      '323042',
      1.175174,
      ' 2- 8-1987',
      '10-25-1983',
      6,
      NULL,
      23.558101,
      8,
      17.740186,
      10,
      26.184711,
      NULL,
      23,
      7,
      31,
      4.189597,
      33,
      23,
      3,
      NULL,
      25,
      1.029262,
      44.198504,
      NULL,
      15,
      7.916052,
      61.358332,
      7,
      1,
      61.580033,
      NULL,
      55.394400,
      NULL,
      34,
      NULL,
      ' 8-11-1988',
      NULL,
      15,
      7,
      26.359052,
      40.366517,
      175,
      NULL,
      4.148568,
      0,
      0,
      0.752401,
      3,
      NULL,
      NULL,
      0.087165,
      1.359849,
      1.761403,
      NULL,
      NULL,
      1.761193,
      0,
      3.030581,
      NULL,
      0,
      0.950671,
      NULL,
      0.538806,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-19-1998',
      11,
      12,
      4,
      15.804155,
      2,
      11,
      ' 7- 7-1995',
      1,
      0,
      4,
      1,
      3,
      14,
      NULL,
      0,
      10.566018,
      0.375319,
      1,
      87.733169,
      ' 3- 0-1991',
      68,
      98,
      98,
      NULL,
      93,
      3,
      13,
      NULL,
      48,
      NULL,
      62,
      17,
      '10-24-1984',
      NULL,
      NULL,
      16.771797,
      35.634947,
      69.908300,
      77,
      NULL,
      ' 0-19-1981',
      12.931836,
      11.565950,
      '11-24-1988',
      1,
      9,
      11,
      7.318829,
      23,
      NULL,
      1,
      3.360211,
      0,
      75,
      0,
      NULL,
      0,
      30.012057,
      1,
      3.999914,
      2,
      0,
      NULL,
      NULL,
      2.332502,
      0.859207,
      ' 0- 6-2002',
      65.312204,
      NULL,
      '10-21-1998',
      26.486147,
      7,
      '10-27-1983',
      7.053608,
      NULL,
      27,
      ' 3-18-1996',
      14,
      NULL,
      ' 6-27-1977',
      16.357683,
      14.442140,
      ' 0- 1-1981',
      1.618404,
      NULL,
      '11- 8-1992',
      0.383745,
      1,
      ' 0-13-1995',
      1,
      3,
      13.832586,
      ' 5-27-1979',
      11,
      6,
      15.130092,
      ' 5- 1-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.113165);
commit;
end;
/


