set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3279727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '1',
      '1',
      NULL,
      '1',
      '2',
      '1',
      '1',
      '3',
      '1',
      '1',
      '4',
      '3',
      NULL,
      '4',
      '0',
      '1',
      NULL,
      '3',
      '2',
      NULL,
      '3',
      '2',
      '',
      '2',
      '',
      '4',
      '3',
      '1',
      '2',
      NULL,
      '',
      '',
      NULL,
      '2',
      '3',
      '2',
      '3',
      '0',
      '2',
      NULL,
      '4',
      '3',
      NULL,
      '002',
      '32044123',
      37,
      22,
      NULL,
      1,
      0,
      0,
      0,
      '030220',
      2,
      NULL,
      NULL,
      NULL,
      102.667859,
      5,
      NULL,
      14,
      3.303192,
      NULL,
      4,
      4,
      15.620148,
      6,
      19,
      29.157524,
      4,
      7,
      7,
      30.275867,
      17,
      41.954351,
      NULL,
      NULL,
      11,
      NULL,
      23.339657,
      0.416632,
      10,
      102.489980,
      88,
      NULL,
      175,
      106,
      ' 0-26-1975',
      23,
      NULL,
      NULL,
      17.805785,
      NULL,
      149.897295,
      ' 8- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      3.129085,
      3.309029,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      25,
      1,
      0,
      165.950538,
      0.402028,
      0.954289,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-13-2002',
      44,
      NULL,
      4.899685,
      42,
      NULL,
      111,
      85.872379,
      94.026296,
      27,
      97.364371,
      41,
      93,
      NULL,
      9,
      23,
      6.630752,
      32.528072,
      86.296107,
      161,
      6,
      ' 8-22-1988',
      NULL,
      NULL,
      ' 2- 6-1979',
      12,
      5,
      18,
      28,
      22,
      15,
      NULL,
      17.978536,
      0.632228,
      124.479420,
      NULL,
      8.813291,
      11,
      24.397245,
      5.890807,
      0,
      0,
      1.041250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 4-24-1987',
      NULL,
      NULL,
      NULL,
      31.425773,
      ' 2-25-2000',
      51,
      ' 6-20-1975',
      11.889772,
      14.878056,
      ' 7-20-2002',
      40.158076,
      13.598153,
      ' 4-17-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      6.162376,
      ' 2-15-2000',
      49,
      53,
      27,
      ' 6- 5-1989',
      1.854105,
      NULL,
      ' 9-22-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


