set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9758092';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '2',
      '3',
      '2',
      '3',
      NULL,
      '2',
      '1',
      '0',
      '3',
      '0',
      '4',
      '3',
      '3',
      '1',
      '4',
      '4',
      '1',
      '2',
      NULL,
      '2',
      NULL,
      '3',
      '',
      NULL,
      '',
      '2',
      '1',
      '3',
      '3',
      NULL,
      '',
      NULL,
      '3',
      '0',
      '2',
      '1',
      '1',
      '2',
      NULL,
      '0',
      '2',
      '0',
      NULL,
      '121',
      '41401104',
      19,
      11.315820,
      '1231334',
      1.016784,
      0,
      2,
      NULL,
      '132044',
      4,
      ' 0-15-2003',
      ' 3-24-1990',
      81,
      132.054566,
      13,
      8.948695,
      15,
      3.628177,
      4.062457,
      7,
      2.399113,
      2.717525,
      11,
      1.981767,
      15,
      9,
      5.435125,
      0.205411,
      16.185636,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580859,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 1-1994',
      NULL,
      17.407606,
      0.577466,
      13,
      142.204963,
      77.001808,
      ' 2-21-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      NULL,
      4.791853,
      4.024833,
      15.051866,
      4,
      ' 7-15-1988',
      1,
      0,
      33,
      NULL,
      0,
      8,
      0.877304,
      1.437848,
      51.290918,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      78,
      39.141428,
      51,
      9,
      55.141875,
      99,
      NULL,
      53.990612,
      43,
      36.235099,
      83.837354,
      ' 4- 4-1999',
      6.649953,
      6,
      9,
      15,
      6.718676,
      3.040187,
      0,
      ' 6- 7-1993',
      0.436749,
      8.537448,
      ' 9-10-1985',
      3,
      2.200301,
      17,
      10.533135,
      10.362833,
      7.128867,
      0,
      0,
      NULL,
      54,
      NULL,
      0,
      8.905225,
      24,
      2,
      NULL,
      0,
      0,
      ' 5- 5-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      52.182969,
      7.817955,
      '11- 8-1979',
      NULL,
      NULL,
      NULL,
      43.470257,
      ' 9-29-1979',
      47.448748,
      ' 3-11-1979',
      2,
      5.583772,
      ' 5-20-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      ' 0-14-1982',
      38,
      NULL,
      23,
      NULL,
      1.609968,
      34.889926,
      ' 1- 3-1996',
      1.478007,
      58,
      1,
      11.983851,
      NULL,
      46.186076,
      0.861676,
      28,
      ' 3-20-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


