set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9008277';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0232',
      '14200010',
      '24434410',
      NULL,
      '40141142',
      '41434244',
      '43031113',
      '20424144',
      NULL,
      NULL,
      '03224132',
      NULL,
      '23021424',
      NULL,
      NULL,
      '32021024',
      '04401130',
      '01141203',
      '34143123',
      '10122321',
      NULL,
      '33141220',
      '43030440',
      '31101020',
      '14444041',
      '21003041',
      NULL,
      '31011241',
      '10333300',
      NULL,
      '14022332',
      '34443141',
      '02342413',
      '14223430',
      '34344132',
      NULL,
      '31224131',
      '13344200',
      '22443040',
      NULL,
      '44002200',
      '43334122',
      '21120021',
      '02404012',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '3304111',
      3,
      1,
      2,
      NULL,
      '324122',
      3.163248,
      ' 1-19-2003',
      ' 7-21-2000',
      82,
      NULL,
      19.714757,
      3,
      20,
      11,
      10.172295,
      5.571535,
      4,
      NULL,
      28.846650,
      9,
      8,
      3.424308,
      29,
      NULL,
      23,
      NULL,
      6.077163,
      11,
      39,
      7.269046,
      121,
      0,
      NULL,
      NULL,
      144.991835,
      NULL,
      19.049509,
      24.282409,
      8,
      ' 8- 4-1991',
      19.961173,
      0,
      0.268518,
      NULL,
      80,
      89.271012,
      ' 7-20-1990',
      1,
      3.882598,
      1,
      3.305945,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268237,
      0.942108,
      3.146163,
      1.337829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-16-1994',
      NULL,
      52.895092,
      59,
      63.339232,
      109.515517,
      38,
      78,
      NULL,
      63.488469,
      NULL,
      16,
      87.368113,
      ' 4-18-1985',
      14,
      11.124305,
      NULL,
      83.155320,
      8,
      106.749611,
      7.935244,
      ' 2-21-2002',
      NULL,
      9,
      ' 0- 0-1990',
      NULL,
      4,
      NULL,
      6,
      4.339877,
      NULL,
      NULL,
      21,
      NULL,
      19.375031,
      4,
      1.456898,
      3.580701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 2-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.312137,
      9,
      NULL,
      NULL,
      0,
      251,
      ' 1-18-1975',
      7.477927,
      28.761956,
      23.654921,
      45.240643,
      '10-29-1990',
      35,
      NULL,
      135.216022,
      ' 9-11-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      167,
      157.769956,
      24.284087,
      69.903468,
      22.299885,
      26,
      3,
      13.487967,
      NULL,
      6,
      10.496181,
      1.662416,
      0,
      10,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.273133,
      3,
      NULL,
      NULL,
      25.805101,
      63.104960,
      1.223071,
      78.646783,
      1,
      1,
      1,
      NULL,
      0,
      3,
      29,
      23,
      57,
      20.983533,
      77,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.728829,
      39.774375,
      24.741579,
      13.920117,
      27.519121,
      38.077714,
      23,
      NULL,
      NULL,
      15.575270,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      3.112277,
      49.270754,
      ' 7-22-1989',
      ' 7-23-1986',
      NULL,
      NULL,
      '10- 2-2002',
      NULL,
      NULL,
      NULL);
commit;
end;
/


