set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926078';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1044',
      '04431030',
      NULL,
      '13222240',
      '31243220',
      '42333331',
      '41124214',
      '11302101',
      '40320223',
      '32033130',
      '20414103',
      '21031234',
      '20010443',
      NULL,
      '30013400',
      '30342341',
      '12141102',
      '11312231',
      '41411100',
      '30414140',
      '12424120',
      '00333303',
      '32232223',
      '42204321',
      '10020440',
      '23030304',
      '20340224',
      '11022130',
      '30204143',
      '01230312',
      NULL,
      NULL,
      '03433133',
      '12022044',
      '04214240',
      '34403424',
      '43420332',
      '30000143',
      '11410313',
      '11222142',
      '00323311',
      '24424102',
      '12200301',
      '33314400',
      '33434213',
      '',
      '',
      NULL,
      NULL,
      '2123222',
      3,
      1.753901,
      NULL,
      NULL,
      NULL,
      0.323861,
      ' 4- 5-1974',
      ' 7-25-1983',
      NULL,
      NULL,
      21,
      NULL,
      8,
      6,
      75.874149,
      0,
      15.739763,
      13,
      3,
      13.278890,
      NULL,
      3,
      NULL,
      NULL,
      5.546345,
      0,
      46,
      7.059379,
      10.742969,
      0,
      33.573506,
      8.171921,
      NULL,
      66.363005,
      92,
      22.429650,
      116.751955,
      60.802197,
      39,
      NULL,
      35,
      12,
      29.762842,
      6,
      NULL,
      NULL,
      ' 0-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 6-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.950139,
      8.563933,
      3.153911,
      58,
      56,
      NULL,
      7,
      NULL,
      NULL,
      17,
      ' 0-29-2001',
      11,
      15.226552,
      2.567434,
      15.071835,
      14,
      7.510045,
      NULL,
      15.549717,
      NULL,
      24.528402,
      NULL,
      3,
      7.610537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 6-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-22-1992',
      3.824460,
      355,
      NULL,
      2.284505,
      10,
      23.165323,
      36,
      ' 7-19-1990',
      27,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436063,
      80,
      53.085424,
      NULL,
      9,
      NULL,
      NULL,
      14.895369,
      NULL,
      1.571466,
      NULL,
      1.657429,
      1,
      40,
      1.729845,
      0,
      12,
      1,
      3,
      40,
      NULL,
      4.970228,
      9,
      1,
      17.868823,
      0,
      1.678205,
      1.371625,
      2.249817,
      NULL,
      3,
      52.389379,
      NULL,
      19,
      3,
      29.348194,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      0.453816,
      54.155482,
      1.706653,
      0.346049,
      51,
      NULL,
      14,
      11,
      3.362912,
      NULL,
      9,
      3.503705,
      3.623905,
      NULL,
      NULL,
      NULL,
      1.425867,
      NULL,
      4,
      3.064955,
      NULL,
      ' 5-25-1978',
      ' 9-29-2003',
      ' 3-10-1981',
      ' 4- 4-1982',
      ' 4-13-1996',
      ' 0-27-1997',
      ' 4- 8-1986',
      NULL);
commit;
end;
/


