set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9815584';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      '1',
      '1',
      '3',
      '3',
      '3',
      '1',
      '1',
      NULL,
      NULL,
      '3',
      '4',
      '1',
      '2',
      '2',
      '3',
      '3',
      '1',
      '2',
      '4',
      '3',
      NULL,
      '4',
      NULL,
      NULL,
      '',
      '0',
      '1',
      '0',
      '0',
      '0',
      '',
      NULL,
      '1',
      '1',
      '0',
      '4',
      '3',
      '4',
      '0',
      NULL,
      '3',
      '3',
      '3',
      '223',
      '04134011',
      39.434377,
      NULL,
      '1411212',
      2.202203,
      1.576531,
      3,
      NULL,
      NULL,
      4,
      ' 0- 7-2001',
      NULL,
      72.648940,
      NULL,
      50.101209,
      12.204155,
      36,
      NULL,
      57,
      NULL,
      24,
      4,
      28,
      27,
      NULL,
      5.000386,
      1,
      NULL,
      19.988668,
      11.523101,
      75.947378,
      1,
      14.247701,
      7.232328,
      132,
      21,
      0.624719,
      82,
      NULL,
      120,
      87,
      250,
      218.011547,
      ' 9-26-1990',
      13.461127,
      67.590678,
      11.063499,
      NULL,
      88,
      8.840558,
      ' 3-29-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65.512553,
      4.536348,
      5.693542,
      3.307536,
      5.649537,
      2,
      NULL,
      1.123196,
      1,
      109.127213,
      0.698594,
      NULL,
      NULL,
      1,
      3.465530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      96,
      NULL,
      44.794001,
      59.738635,
      47,
      73.284353,
      81.551043,
      79.139966,
      NULL,
      0.276150,
      67,
      15,
      NULL,
      24.454078,
      23,
      11.161857,
      66.567549,
      49.954436,
      69.735608,
      4,
      ' 0-21-1978',
      7.456521,
      24.861216,
      NULL,
      10.197357,
      4.049855,
      NULL,
      0.679346,
      12.594828,
      NULL,
      0.008106,
      14.678769,
      0.725922,
      155,
      1,
      3,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      '11-19-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 7-28-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 7-1993',
      17,
      ' 0-24-1991',
      NULL,
      14,
      NULL,
      40.727614,
      44,
      '11- 5-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 5-28-1983',
      13,
      NULL,
      40,
      ' 5-28-1991',
      0.267378,
      14.271264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


