set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4011',
      NULL,
      '22032111',
      '00020330',
      '40211310',
      '04014110',
      '11341342',
      '00014332',
      '31131011',
      '44231120',
      '23022140',
      NULL,
      '01112431',
      '04414103',
      '40122403',
      '12211000',
      '42312231',
      NULL,
      '02410412',
      '30403003',
      '32330224',
      NULL,
      '44300121',
      NULL,
      '12114213',
      NULL,
      '33444023',
      NULL,
      '01003331',
      NULL,
      '42222340',
      NULL,
      '42422200',
      '01203313',
      '13302412',
      '31411043',
      '22010410',
      '42234411',
      NULL,
      NULL,
      NULL,
      '14304114',
      '10031304',
      '31320012',
      NULL,
      '220',
      NULL,
      NULL,
      NULL,
      '0310212',
      0,
      0,
      NULL,
      NULL,
      '123042',
      5.736218,
      NULL,
      ' 7- 1-1988',
      30,
      NULL,
      12,
      0.734248,
      23.192140,
      16,
      62.361570,
      18.569929,
      14.228581,
      5,
      6.902683,
      NULL,
      NULL,
      NULL,
      12.928345,
      11.667013,
      14,
      NULL,
      25,
      12,
      0.189676,
      NULL,
      NULL,
      NULL,
      0.154100,
      37.292673,
      170,
      4,
      31,
      15,
      104.528448,
      NULL,
      34.962016,
      0,
      34.565106,
      32.179931,
      114,
      NULL,
      ' 4-15-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      17,
      18,
      11.317043,
      4,
      7,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      52,
      0.318069,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      '11-27-1974',
      108.770381,
      82,
      43.006981,
      31.618644,
      68.325006,
      33,
      34,
      65,
      33.573315,
      80.392054,
      30,
      52.190235,
      ' 6- 5-1987',
      22.203652,
      16,
      25.850803,
      17.343598,
      44.589785,
      86,
      NULL,
      ' 9-19-2001',
      9.042110,
      13,
      ' 3- 5-1995',
      6.008860,
      6,
      6,
      28.035989,
      NULL,
      10,
      1,
      14.312835,
      1.261209,
      79,
      0.690792,
      3.546675,
      9.281000,
      29,
      NULL,
      1.015080,
      1,
      1,
      NULL,
      3,
      2,
      0,
      ' 4-20-2003',
      36,
      6,
      '11-24-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-1993',
      15,
      ' 8- 3-1974',
      NULL,
      14,
      ' 3-25-1997',
      59,
      53.102560,
      '10- 4-1986',
      NULL,
      4,
      NULL,
      0,
      9,
      ' 5-25-1977',
      1,
      3,
      NULL,
      ' 9-16-2003',
      53.795724,
      6.712329,
      28,
      ' 4- 2-1977',
      NULL,
      156,
      ' 9-27-1982',
      11.569533,
      47,
      14.777827,
      29.046516,
      ' 4-18-1991',
      NULL,
      1.108786,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.657102);
commit;
end;
/


