set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01201004',
      '34012333',
      '32134320',
      '32300020',
      '21231414',
      '10431110',
      '14421033',
      '24434210',
      '00134002',
      NULL,
      '13241133',
      '24030144',
      '24102122',
      '13123130',
      '41213103',
      '32011420',
      '32003144',
      '21230302',
      NULL,
      NULL,
      '34133200',
      '31020034',
      '20223241',
      '44300002',
      '33402331',
      NULL,
      '33244231',
      '11103142',
      '34114010',
      '21204142',
      '31424300',
      '03040000',
      NULL,
      '44000404',
      '03143104',
      NULL,
      '12400403',
      '30231403',
      NULL,
      NULL,
      '31141421',
      '41402131',
      NULL,
      '01024304',
      '223',
      '11',
      NULL,
      NULL,
      '3342120',
      2.229583,
      28.912622,
      NULL,
      NULL,
      '343311',
      NULL,
      NULL,
      ' 6-13-1980',
      5,
      NULL,
      27,
      9.736445,
      25.779634,
      3.022774,
      94.899517,
      NULL,
      20,
      1,
      2.556220,
      NULL,
      24,
      NULL,
      NULL,
      7.993214,
      NULL,
      NULL,
      55,
      NULL,
      NULL,
      1.154167,
      35.452178,
      1,
      0.456444,
      27,
      110,
      NULL,
      NULL,
      8,
      2,
      ' 6-27-1984',
      NULL,
      58.948266,
      26,
      6,
      NULL,
      109,
      ' 8- 5-1979',
      0.371800,
      0,
      0.139007,
      0,
      3,
      3,
      1.652269,
      0,
      NULL,
      NULL,
      2.570826,
      NULL,
      0,
      1.440709,
      1,
      1,
      0.457067,
      0,
      1.877726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-29-1992',
      83.003095,
      NULL,
      5.115685,
      NULL,
      0,
      5.101644,
      ' 6-26-1994',
      NULL,
      0,
      162.358296,
      1,
      0,
      98.708708,
      0,
      0.621815,
      15.244209,
      NULL,
      NULL,
      NULL,
      '10-28-1980',
      NULL,
      70.840248,
      32.057203,
      95,
      2,
      3.913098,
      56,
      39.303191,
      23,
      40,
      48.711958,
      47,
      ' 1- 2-1989',
      27,
      30.519656,
      14,
      72,
      68.492211,
      80.530042,
      13,
      NULL,
      22.904830,
      0.412795,
      ' 2-26-2000',
      3.270502,
      19.903564,
      16.254144,
      27.198821,
      NULL,
      NULL,
      0.282441,
      18,
      1.871699,
      69.524551,
      1.073643,
      7.710475,
      NULL,
      28,
      1,
      NULL,
      3.290012,
      1,
      ' 6- 8-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      32.749674,
      3,
      ' 5-17-1995',
      NULL,
      NULL,
      NULL,
      16,
      ' 9- 1-1989',
      38.609199,
      ' 1-28-1974',
      10,
      NULL,
      ' 1- 5-1993',
      NULL,
      NULL,
      NULL,
      4.129519,
      13.989996,
      ' 2- 8-1978',
      NULL,
      NULL,
      NULL,
      1,
      2,
      12,
      NULL,
      31.917477,
      9.984133,
      6,
      ' 4-21-1990',
      0,
      5.892833,
      NULL,
      4,
      5.423904,
      NULL,
      NULL,
      ' 8- 8-1975',
      NULL,
      1,
      159.090351,
      ' 8-17-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


