set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0414',
      '33414434',
      '01234443',
      '20214123',
      '12234102',
      '00030321',
      '40042334',
      '43440031',
      '24011411',
      '13410133',
      '22440401',
      '22322211',
      NULL,
      '10442421',
      '30120443',
      '04433114',
      NULL,
      NULL,
      '04110001',
      '42303442',
      '21423433',
      '13420042',
      '10441424',
      '24211341',
      '03210041',
      '22104213',
      '34341423',
      '14422123',
      '14340023',
      '00431113',
      '21014333',
      '13410334',
      '42131113',
      '30110132',
      '23014224',
      '23000204',
      '33133431',
      '14444202',
      '31300130',
      '11030020',
      '20313430',
      '22022143',
      '14131303',
      '12223133',
      '14243131',
      '032',
      '40',
      29.720201,
      22,
      '4030241',
      3.143332,
      21,
      2,
      NULL,
      NULL,
      3.715104,
      ' 4-26-1978',
      ' 8-23-1997',
      NULL,
      NULL,
      0.824002,
      21,
      13,
      18.027380,
      111.119768,
      NULL,
      NULL,
      NULL,
      28.850479,
      21.654736,
      32.726161,
      3,
      27.798204,
      14.442846,
      14.248474,
      2.662712,
      NULL,
      17,
      52.234029,
      8,
      9,
      NULL,
      0.855242,
      51,
      61,
      NULL,
      NULL,
      234,
      NULL,
      ' 4-26-1996',
      39,
      NULL,
      31,
      NULL,
      184,
      40,
      '10-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.232806,
      NULL,
      15,
      NULL,
      5,
      1.620963,
      ' 8- 3-1990',
      0.596739,
      2.674396,
      163,
      1.363825,
      NULL,
      92.143175,
      1,
      3,
      65.980527,
      NULL,
      NULL,
      NULL,
      ' 4-28-1999',
      96.703061,
      16.736416,
      69,
      NULL,
      73.552482,
      NULL,
      48.129581,
      8,
      3.444892,
      20,
      55,
      33,
      NULL,
      14.376808,
      25,
      16,
      NULL,
      NULL,
      NULL,
      5.281485,
      ' 7-27-1998',
      9.911025,
      22,
      '10- 3-1999',
      NULL,
      7,
      17,
      28.573177,
      15.123205,
      3.493222,
      0,
      NULL,
      0,
      NULL,
      0.667598,
      3,
      NULL,
      5,
      1,
      NULL,
      0.905695,
      NULL,
      ' 6-27-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      44.334881,
      1,
      ' 8-18-1995',
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      28,
      ' 9- 9-1996',
      10.655606,
      NULL,
      '11-14-1993',
      18,
      16.326873,
      ' 8- 5-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      ' 0-23-1993',
      NULL,
      1.145291,
      4,
      NULL,
      0.581385,
      NULL,
      ' 0-26-1990',
      0.271476,
      4,
      17,
      NULL,
      '10- 2-1982',
      37,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


