set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '4',
      '3',
      NULL,
      '0',
      '3',
      '2',
      '2',
      '0',
      NULL,
      '3',
      '1',
      '3',
      NULL,
      '0',
      '4',
      '0',
      NULL,
      '2',
      '4',
      '0',
      '2',
      '0',
      '',
      '4',
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      '1',
      '',
      '',
      NULL,
      NULL,
      '1',
      '3',
      '4',
      '2',
      '1',
      NULL,
      NULL,
      '2',
      '0',
      '111',
      '42330430',
      NULL,
      64,
      '0123102',
      1,
      117.198428,
      0,
      1,
      '434100',
      NULL,
      ' 1- 6-2003',
      ' 7-28-1980',
      28.366757,
      6,
      3.394095,
      9,
      22.848546,
      NULL,
      121.590593,
      24.136424,
      25,
      14,
      13,
      NULL,
      45,
      4,
      4,
      6,
      NULL,
      17.896936,
      3.909882,
      14,
      1.099672,
      1.280401,
      2.179297,
      NULL,
      NULL,
      78,
      149.240545,
      79,
      156.722493,
      43.903552,
      104,
      ' 4- 2-1994',
      44.093610,
      NULL,
      26,
      15.008687,
      146.634193,
      232,
      '10-15-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      28.987764,
      12,
      10,
      0,
      6.905768,
      ' 4-18-2001',
      1.399638,
      3.359721,
      166,
      0,
      3,
      56.809092,
      3,
      5.557201,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      60,
      NULL,
      88.322853,
      33,
      41,
      NULL,
      66,
      60.375865,
      NULL,
      92.063151,
      ' 6-19-1976',
      NULL,
      23,
      17,
      4,
      78.220871,
      NULL,
      NULL,
      ' 4-25-1977',
      7,
      23.226867,
      '10-21-1993',
      NULL,
      11,
      16,
      19.892986,
      20.826422,
      7.857710,
      NULL,
      1.229612,
      1.553312,
      102.760168,
      0.450607,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      ' 0-11-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      120,
      NULL,
      '10-12-1989',
      NULL,
      NULL,
      NULL,
      24,
      ' 5-20-1988',
      3,
      '10-13-1992',
      8,
      7,
      ' 0- 4-1974',
      87,
      110.774119,
      '10-24-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      9.774167,
      ' 2-21-1987',
      41,
      NULL,
      10.043467,
      ' 7-14-1988',
      1.573594,
      126.909916,
      ' 7- 4-1995',
      13,
      NULL,
      13.221356,
      107.313278,
      ' 7-15-1988',
      38,
      0.191858,
      190.811824,
      ' 0- 9-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


