set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604647';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '42301403',
      '32214200',
      '43304131',
      NULL,
      '43024403',
      '11130123',
      '10203121',
      '44002431',
      NULL,
      NULL,
      '11012023',
      '30012301',
      '00144223',
      '24224343',
      '34414004',
      '11120344',
      '42300023',
      '31123300',
      '12323230',
      '34114230',
      '00040202',
      NULL,
      '21234422',
      '31111432',
      '31032103',
      '13340243',
      '24340221',
      '30432241',
      '33213330',
      '33324023',
      '41020133',
      '34323430',
      '23410123',
      '02313033',
      '20012344',
      '03401431',
      '03122332',
      '34114344',
      NULL,
      '11232342',
      '21240014',
      '31341034',
      '21043131',
      '401',
      '40',
      NULL,
      NULL,
      '2111431',
      2,
      1.263336,
      1,
      NULL,
      '124240',
      0.923307,
      ' 6- 5-1974',
      ' 7- 5-2001',
      10.063041,
      NULL,
      NULL,
      NULL,
      18.194856,
      10,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      37.933646,
      2.575053,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      17.609096,
      NULL,
      NULL,
      74.634978,
      13.792330,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 4-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.630810,
      3.742329,
      2,
      0,
      4,
      2,
      NULL,
      NULL,
      0.868293,
      1.283719,
      NULL,
      NULL,
      NULL,
      0.735147,
      1,
      0.041481,
      1,
      NULL,
      0.800630,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-15-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331356,
      NULL,
      73.257523,
      1.334075,
      NULL,
      32,
      1.148737,
      0.210641,
      59.479412,
      1,
      0,
      207,
      NULL,
      NULL,
      97.760458,
      NULL,
      NULL,
      51,
      NULL,
      6.035413,
      NULL,
      12.814136,
      0,
      82,
      NULL,
      ' 9-11-1993',
      8,
      18.238085,
      7,
      75.357751,
      50.285278,
      NULL,
      6.937185,
      ' 9-25-1992',
      NULL,
      NULL,
      NULL,
      0.108697,
      3,
      9.207507,
      NULL,
      6,
      0.117911,
      1,
      8.478093,
      1,
      104,
      0,
      6,
      NULL,
      23.935640,
      1.914128,
      NULL,
      1.676419,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      15,
      ' 5- 8-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      117,
      ' 1-26-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


