set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9671395';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0040',
      '04044202',
      '04442001',
      '33010130',
      '11201431',
      '10444233',
      '23313323',
      '44133113',
      NULL,
      '14420242',
      NULL,
      NULL,
      '41231040',
      NULL,
      '31303134',
      NULL,
      NULL,
      '02220403',
      NULL,
      '32143140',
      '10323041',
      NULL,
      '23322303',
      '13134011',
      '21022302',
      NULL,
      '11101013',
      NULL,
      '40242001',
      '21140243',
      '22422422',
      NULL,
      '41414333',
      NULL,
      '12422432',
      '04104144',
      '40312202',
      '31110120',
      '22414034',
      '24404122',
      '42344332',
      '41102434',
      '04103224',
      '21123204',
      '33333143',
      NULL,
      '34',
      15.790487,
      11,
      '3311322',
      0,
      0,
      3,
      NULL,
      '404300',
      NULL,
      ' 4-16-1988',
      ' 8-17-1979',
      NULL,
      30.140715,
      32.265248,
      12.967393,
      1.947743,
      9,
      NULL,
      11.614330,
      8.643783,
      NULL,
      29.187926,
      17.875372,
      NULL,
      4,
      19,
      NULL,
      4,
      NULL,
      5.642912,
      11.746014,
      13.774337,
      2.141373,
      53.348971,
      2.557168,
      NULL,
      67,
      9,
      25.751864,
      66,
      21,
      27.922879,
      ' 3-25-2001',
      24.600350,
      NULL,
      14,
      13.754794,
      NULL,
      90,
      ' 5-15-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      12.668197,
      50,
      0.562149,
      40.495595,
      NULL,
      ' 1- 2-1984',
      1.836703,
      NULL,
      126.508878,
      0.789326,
      1.686483,
      63.726713,
      1.917493,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 0-1993',
      20,
      NULL,
      NULL,
      83,
      7,
      79,
      73,
      68,
      61,
      28,
      37,
      17.943010,
      '10-25-1990',
      13,
      1,
      3.004026,
      6.559257,
      56,
      13,
      9.319799,
      ' 3- 2-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.864626,
      59.496793,
      ' 2-29-1991',
      NULL,
      NULL,
      NULL,
      0.846004,
      ' 6-25-1988',
      NULL,
      NULL,
      NULL,
      12.790359,
      ' 2-29-1994',
      8,
      1,
      ' 1-18-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      '10-11-1989',
      NULL,
      NULL,
      7.533136,
      ' 3- 1-1992',
      NULL,
      120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.184514,
      NULL,
      26.909944,
      ' 3- 1-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


